/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Cookie;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Request;

public class CookieHeader
extends Header {
    public static final String NAME = "Cookie";
    private final List<Cookie> cookies;

    private static CookieHeader valueOf(List<String> values2) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(values2.size());
        Integer version = null;
        Cookie cookie = new Cookie();
        for (String s1 : values2) {
            for (String s2 : HeaderUtil.split(s1, ';')) {
                String[] nvp = HeaderUtil.parseParameter(s2);
                if (nvp[0].length() > 0 && nvp[0].charAt(0) != '$') {
                    if (cookie.getName() != null) {
                        cookies.add(cookie);
                    }
                    cookie = new Cookie();
                    cookie.setVersion(version);
                    cookie.setName(nvp[0]);
                    cookie.setValue(nvp[1]);
                    continue;
                }
                if ("$Version".equalsIgnoreCase(nvp[0])) {
                    version = CookieHeader.parseInteger(nvp[1]);
                    cookie.setVersion(version);
                    continue;
                }
                if ("$Path".equalsIgnoreCase(nvp[0])) {
                    cookie.setPath(nvp[1]);
                    continue;
                }
                if ("$Domain".equalsIgnoreCase(nvp[0])) {
                    cookie.setDomain(nvp[1]);
                    continue;
                }
                if (!"$Port".equalsIgnoreCase(nvp[0])) continue;
                cookie.getPort().clear();
                CookieHeader.parsePorts(cookie.getPort(), nvp[1]);
            }
        }
        if (cookie.getName() != null) {
            cookies.add(cookie);
        }
        return new CookieHeader(cookies);
    }

    private static void parsePorts(List<Integer> list2, String s2) {
        for (String port : s2.split(",")) {
            Integer p2 = CookieHeader.parseInteger(port);
            if (p2 == null) continue;
            list2.add(p2);
        }
    }

    private static Integer parseInteger(String s2) {
        try {
            return Integer.valueOf(s2);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static CookieHeader valueOf(Request message2) {
        return CookieHeader.valueOf(HeaderUtil.parseMultiValuedHeader(message2, NAME));
    }

    public static CookieHeader valueOf(String string2) {
        return CookieHeader.valueOf(HeaderUtil.parseMultiValuedHeader(string2));
    }

    public CookieHeader() {
        this(new ArrayList<Cookie>(1));
    }

    public CookieHeader(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        boolean quoted = false;
        Integer version = null;
        for (Cookie cookie : this.cookies) {
            if (cookie.getVersion() != null && (version == null || cookie.getVersion() > version)) {
                version = cookie.getVersion();
                continue;
            }
            if (version != null || cookie.getPath() == null && cookie.getDomain() == null) continue;
            version = 1;
        }
        StringBuilder sb = new StringBuilder();
        if (version != null) {
            sb.append("$Version=").append(version.toString());
            quoted = true;
        }
        for (Cookie cookie : this.cookies) {
            if (cookie.getName() == null) continue;
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(cookie.getName()).append('=');
            sb.append(quoted ? HeaderUtil.quote(cookie.getValue()) : cookie.getValue());
            if (cookie.getPath() != null) {
                sb.append("; $Path=").append(HeaderUtil.quote(cookie.getPath()));
            }
            if (cookie.getDomain() != null) {
                sb.append("; $Domain=").append(HeaderUtil.quote(cookie.getDomain()));
            }
            if (cookie.getPort().size() <= 0) continue;
            sb.append("; $Port=").append(HeaderUtil.quote(this.portList(cookie.getPort())));
        }
        return sb.length() > 0 ? Collections.singletonList(sb.toString()) : Collections.emptyList();
    }

    private String portList(List<Integer> ports) {
        StringBuilder sb = new StringBuilder();
        for (Integer port : ports) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(port.toString());
        }
        return sb.toString();
    }

    static class Factory
    extends HeaderFactory<CookieHeader> {
        Factory() {
        }

        @Override
        public CookieHeader parse(String value2) {
            return CookieHeader.valueOf(value2);
        }

        @Override
        public CookieHeader parse(List<String> values2) {
            return CookieHeader.valueOf(values2);
        }
    }
}

