/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.header.AcceptLanguageHeader;
import org.forgerock.http.header.ConnectionHeader;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.ContentEncodingHeader;
import org.forgerock.http.header.ContentLengthHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.header.CookieHeader;
import org.forgerock.http.header.LocationHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.header.SetCookieHeader;
import org.forgerock.http.header.TransactionIdHeader;
import org.forgerock.http.header.WarningHeader;
import org.forgerock.http.protocol.Header;

public abstract class HeaderFactory<H extends Header> {
    public static final Map<Class<? extends Header>, String> HEADER_NAMES = Collections.unmodifiableMap(new HashMap<Class<? extends Header>, String>(){
        {
            this.put(AcceptApiVersionHeader.class, "Accept-API-Version");
            this.put(AcceptLanguageHeader.class, "Accept-Language");
            this.put(ConnectionHeader.class, "Connection");
            this.put(ContentApiVersionHeader.class, "Content-API-Version");
            this.put(ContentEncodingHeader.class, "Content-Encoding");
            this.put(ContentLengthHeader.class, "Content-Length");
            this.put(ContentTypeHeader.class, "Content-Type");
            this.put(CookieHeader.class, "Cookie");
            this.put(LocationHeader.class, "Location");
            this.put(SetCookieHeader.class, "Set-Cookie");
            this.put(TransactionIdHeader.class, "X-ForgeRock-TransactionId");
            this.put(WarningHeader.class, "Warning");
        }
    });
    public static final Map<String, HeaderFactory<?>> FACTORIES = Collections.unmodifiableMap(new TreeMap<String, HeaderFactory<?>>(String.CASE_INSENSITIVE_ORDER){
        {
            this.put("Accept-API-Version", new AcceptApiVersionHeader.Factory());
            this.put("Accept-Language", new AcceptLanguageHeader.Factory());
            this.put("Connection", new ConnectionHeader.Factory());
            this.put("Content-API-Version", new ContentApiVersionHeader.Factory());
            this.put("Content-Encoding", new ContentEncodingHeader.Factory());
            this.put("Content-Length", new ContentLengthHeader.Factory());
            this.put("Content-Type", new ContentTypeHeader.Factory());
            this.put("Cookie", new CookieHeader.Factory());
            this.put("Location", new LocationHeader.Factory());
            this.put("Set-Cookie", new SetCookieHeader.Factory());
            this.put("X-ForgeRock-TransactionId", new TransactionIdHeader.Factory());
            this.put("Warning", new WarningHeader.Factory());
            if (this.size() != HEADER_NAMES.size()) {
                throw new IllegalStateException("Misconfigured maps");
            }
        }

        @Override
        public HeaderFactory<?> put(String key2, HeaderFactory<?> value2) {
            if (!HEADER_NAMES.containsValue(key2)) {
                throw new IllegalStateException("Misconfigured maps");
            }
            return super.put(key2, value2);
        }
    });

    protected abstract H parse(String var1) throws MalformedHeaderException;

    protected abstract H parse(List<String> var1) throws MalformedHeaderException;

    public H parse(Object value2) throws MalformedHeaderException {
        try {
            if (value2 instanceof Header) {
                return this.parse(new ArrayList<String>(((Header)value2).getValues()));
            }
            if (value2 instanceof String) {
                String s2 = (String)value2;
                return s2.isEmpty() ? null : (H)this.parse(s2);
            }
            if (value2 instanceof List) {
                return this.parse((List)value2);
            }
            if (value2.getClass().isArray()) {
                return this.parse(Arrays.asList((String[])value2));
            }
        }
        catch (RuntimeException e) {
            throw new MalformedHeaderException("Could not parse header", e);
        }
        throw new IllegalArgumentException("Cannot parse header value from type: " + value2);
    }
}

