/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.util.CaseInsensitiveMap;

public final class HeaderUtil {
    private static final String HTTP_DATE_RFC_1123_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String LEGACY_RFC_850_DATE_FORMAT = "E, dd-MMM-yy HH:mm:ss zzz";
    private static final String LEGACY_ANSI_C_DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final Pattern UNQUOTE_PATTERN = Pattern.compile("(\\\\)(\\\\|[\"])");

    private HeaderUtil() {
    }

    public static List<String> split(String value2, char separator) {
        if (separator == '\"' || separator == '\\') {
            throw new IllegalArgumentException("invalid separator: " + separator);
        }
        ArrayList<String> values2 = new ArrayList<String>();
        if (value2 != null) {
            int cp;
            int length2 = value2.length();
            StringBuilder sb = new StringBuilder();
            boolean escaped = false;
            boolean quoted = false;
            for (int n = 0; n < length2; n += Character.charCount(cp)) {
                cp = value2.codePointAt(n);
                if (escaped) {
                    sb.appendCodePoint(cp);
                    escaped = false;
                    continue;
                }
                if (cp == 92) {
                    sb.appendCodePoint(cp);
                    if (!quoted) continue;
                    escaped = true;
                    continue;
                }
                if (cp == 34) {
                    sb.appendCodePoint(cp);
                    quoted = !quoted;
                    continue;
                }
                if (cp == separator && !quoted) {
                    String s2 = sb.toString().trim();
                    if (s2.length() > 0) {
                        values2.add(s2);
                    }
                    sb.setLength(0);
                    continue;
                }
                sb.appendCodePoint(cp);
            }
            String s3 = sb.toString().trim();
            if (s3.length() > 0) {
                values2.add(s3);
            }
        }
        return values2;
    }

    public static String join(Collection<String> values2, char separator) {
        if (separator == '\"' || separator == '\\') {
            throw new IllegalArgumentException("invalid separator: " + separator);
        }
        StringBuilder sb = new StringBuilder();
        if (values2 != null) {
            for (String s2 : values2) {
                if (s2 == null) continue;
                if (sb.length() > 0) {
                    sb.append(separator).append(' ');
                }
                sb.append(s2);
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static String[] parseParameter(String value2) {
        int cp;
        String[] ss = new String[2];
        boolean inValue = false;
        boolean quoted = false;
        boolean escaped = false;
        int length2 = value2.length();
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < length2; n += Character.charCount(cp)) {
            cp = value2.codePointAt(n);
            if (escaped) {
                sb.appendCodePoint(cp);
                escaped = false;
                continue;
            }
            if (cp == 92) {
                if (quoted) {
                    escaped = true;
                    continue;
                }
                sb.appendCodePoint(cp);
                continue;
            }
            if (cp == 34) {
                quoted = !quoted;
                continue;
            }
            if (!quoted && !inValue && cp == 61) {
                ss[0] = sb.toString().trim();
                sb.setLength(0);
                inValue = true;
                continue;
            }
            if (!quoted && Character.isWhitespace(cp)) continue;
            sb.appendCodePoint(cp);
        }
        if (!inValue) {
            ss[0] = sb.toString().trim();
        } else {
            ss[1] = sb.toString();
        }
        return ss;
    }

    public static Map<String, String> parseParameters(Collection<String> values2) {
        CaseInsensitiveMap<String> map2 = new CaseInsensitiveMap<String>(new HashMap());
        if (values2 != null) {
            for (String value2 : values2) {
                String[] param = HeaderUtil.parseParameter(value2);
                if (param[0] == null || param[0].length() <= 0 || map2.containsKey(param[0])) continue;
                map2.put(param[0], param[1]);
            }
        }
        return map2;
    }

    public static String quote(String value2) {
        int cp;
        if (value2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("\"");
        int length2 = value2.length();
        for (int n = 0; n < length2; n += Character.charCount(cp)) {
            cp = value2.codePointAt(n);
            if (cp == 92 || cp == 34) {
                sb.append('\\');
            }
            sb.appendCodePoint(cp);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String unquote(String value2) {
        if (value2 == null) {
            return null;
        }
        int n = value2.length();
        if (n < 2 || value2.charAt(0) != '\"' || value2.charAt(n - 1) != '\"') {
            throw new IllegalArgumentException("value is not quoted");
        }
        return UNQUOTE_PATTERN.matcher(value2.substring(1, n - 1)).replaceAll("$2");
    }

    public static List<String> parseMultiValuedHeader(Message message2, String name2) {
        List<String> values2 = message2 != null && message2.getHeaders().containsKey(name2) ? message2.getHeaders().get(name2).getValues() : null;
        return HeaderUtil.parseMultiValuedHeader(HeaderUtil.join(values2, ','));
    }

    public static List<String> parseMultiValuedHeader(String header) {
        return HeaderUtil.split(header, ',');
    }

    public static String parseSingleValuedHeader(Message message2, String name2) {
        if (message2 == null || !message2.getHeaders().containsKey(name2)) {
            return null;
        }
        Iterator<String> iterator = message2.getHeaders().get(name2).getValues().iterator();
        String header = iterator.hasNext() ? iterator.next() : null;
        return header != null ? header : null;
    }

    public static String formatDate(Date date2) {
        return HeaderUtil.getDateFormatter(HTTP_DATE_RFC_1123_DATE_FORMAT).format(date2);
    }

    public static Date parseDate(String s2) {
        if (s2 == null) {
            return null;
        }
        Date date2 = HeaderUtil.parseDate(s2, HTTP_DATE_RFC_1123_DATE_FORMAT);
        if (date2 != null) {
            return date2;
        }
        date2 = HeaderUtil.parseDate(s2, "EEE, dd-MMM-yyyy HH:mm:ss zzz");
        if (date2 != null) {
            return date2;
        }
        date2 = HeaderUtil.parseDate(s2, LEGACY_RFC_850_DATE_FORMAT);
        if (date2 == null) {
            date2 = HeaderUtil.parseDate(s2.replace("day,", ","), LEGACY_RFC_850_DATE_FORMAT);
        }
        if (date2 != null) {
            return date2;
        }
        return HeaderUtil.parseDate(s2, LEGACY_ANSI_C_DATE_FORMAT);
    }

    private static Date parseDate(String s2, String format) {
        try {
            return HeaderUtil.getDateFormatter(format).parse(s2);
        }
        catch (ParseException eee) {
            return null;
        }
    }

    private static SimpleDateFormat getDateFormatter(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ROOT);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    }
}

