/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.util.Reject;

public class Warning {
    private static final Pattern PATTERN = Pattern.compile("([0-9]{3}) ([^ ]+) ([\"].*[\"])");
    private final int code;
    private final String agent;
    private final String text;
    private final Date date;

    public Warning(int code, String agent, String text) {
        this(code, agent, text, null);
    }

    public Warning(int code, String agent, String text, Date date2) {
        Reject.ifNull(agent, text);
        this.code = code;
        this.agent = agent;
        this.text = text;
        this.date = date2;
    }

    public int getCode() {
        return this.code;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getText() {
        return this.text;
    }

    public Date getDate() {
        return this.date;
    }

    public String toString() {
        String s2 = String.valueOf(this.code) + ' ' + this.agent + ' ' + HeaderUtil.quote(this.text);
        if (this.date != null) {
            s2 = s2 + " \"" + HeaderUtil.formatDate(this.date) + '\"';
        }
        return s2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return this.code == warning.code && Objects.equals(this.agent, warning.agent) && Objects.equals(this.text, warning.text) && Objects.equals(this.date, warning.date);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.agent, this.text, this.date);
    }

    public static Warning valueOf(String value2) {
        Matcher m3 = PATTERN.matcher(value2);
        if (m3.matches()) {
            String date2;
            String text;
            int code = Integer.parseInt(m3.group(1));
            String agent = m3.group(2);
            String tail = m3.group(3);
            int dateIndex = tail.lastIndexOf(34, tail.length() - 2);
            if (dateIndex != 0 && tail.charAt(dateIndex - 1) != '\\') {
                text = tail.substring(0, dateIndex - 1);
                date2 = tail.substring(dateIndex);
            } else {
                text = tail;
                date2 = null;
            }
            return new Warning(code, agent, HeaderUtil.unquote(text), HeaderUtil.parseDate(HeaderUtil.unquote(date2)));
        }
        return null;
    }
}

