/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.IOException;
import java.util.Arrays;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.OverflowException;

final class MemoryBuffer
implements Buffer {
    byte[] data;
    private final int limit;
    private int length = 0;

    MemoryBuffer(int initial, int limit2) {
        this.data = new byte[initial];
        this.limit = limit2;
    }

    @Override
    public byte read(int pos2) throws IOException {
        this.notClosed();
        if (pos2 < this.data.length) {
            return this.data[pos2];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int read(int pos2, byte[] b2, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int n = 0;
        if (pos2 < this.length) {
            n = Math.min(len, this.length - pos2);
            System.arraycopy(this.data, pos2, b2, off, n);
        }
        return n;
    }

    @Override
    public void append(byte b2) throws IOException {
        this.notClosed();
        int end2 = this.length + 1;
        this.growBufferIfNecessary(end2);
        this.data[this.length] = b2;
        this.length = end2;
    }

    @Override
    public void append(byte[] b2, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int end2 = this.length + len;
        this.growBufferIfNecessary(end2);
        System.arraycopy(b2, off, this.data, this.length, len);
        this.length = end2;
    }

    private void growBufferIfNecessary(int end2) throws OverflowException {
        if (end2 > this.limit) {
            throw new OverflowException();
        }
        if (this.data.length < end2) {
            this.data = Arrays.copyOf(this.data, Math.max(end2, Math.min(this.limit, this.data.length << 1)));
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void close() {
        this.data = null;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void notClosed() throws IOException {
        if (this.data == null) {
            throw new IOException("buffer is closed");
        }
    }
}

