/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Cookie {
    private String name;
    private String value;
    private String comment;
    private String commentURL;
    private Boolean discard;
    private String domain;
    private Date expires;
    private Boolean httpOnly;
    private Integer maxAge;
    private String path;
    private final List<Integer> port = new ArrayList<Integer>();
    private Boolean secure;
    private Integer version;
    private SameSite sameSite;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)obj;
        return Cookie.objectsAreEqual(this.comment, other.comment) && Cookie.objectsAreEqual(this.commentURL, other.commentURL) && Cookie.objectsAreEqual(this.discard, other.discard) && Cookie.objectsAreEqual(this.domain, other.domain) && Cookie.objectsAreEqual(this.expires, other.expires) && Cookie.objectsAreEqual(this.httpOnly, other.httpOnly) && Cookie.objectsAreEqual(this.maxAge, other.maxAge) && Cookie.objectsAreEqual(this.name, other.name) && Cookie.objectsAreEqual(this.path, other.path) && Cookie.objectsAreEqual(this.port, other.port) && Cookie.objectsAreEqual(this.secure, other.secure) && Cookie.objectsAreEqual((Object)this.sameSite, (Object)other.sameSite) && Cookie.objectsAreEqual(this.value, other.value) && Cookie.objectsAreEqual(this.version, other.version);
    }

    public String getComment() {
        return this.comment;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public Boolean getDiscard() {
        return this.discard;
    }

    public String getDomain() {
        return this.domain;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Boolean isHttpOnly() {
        return this.httpOnly == null ? false : this.httpOnly;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<Integer> getPort() {
        return this.port;
    }

    public Boolean isSecure() {
        return this.secure == null ? false : this.secure;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getVersion() {
        return this.version;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.comment == null ? 0 : this.comment.hashCode());
        result2 = 31 * result2 + (this.commentURL == null ? 0 : this.commentURL.hashCode());
        result2 = 31 * result2 + (this.discard == null ? 0 : this.discard.hashCode());
        result2 = 31 * result2 + (this.domain == null ? 0 : this.domain.hashCode());
        result2 = 31 * result2 + (this.expires == null ? 0 : this.expires.hashCode());
        result2 = 31 * result2 + (this.httpOnly == null ? 0 : this.httpOnly.hashCode());
        result2 = 31 * result2 + (this.maxAge == null ? 0 : this.maxAge.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.path == null ? 0 : this.path.hashCode());
        result2 = 31 * result2 + (this.port == null ? 0 : this.port.hashCode());
        result2 = 31 * result2 + (this.secure == null ? 0 : this.secure.hashCode());
        result2 = 31 * result2 + (this.sameSite == null ? 0 : this.sameSite.hashCode());
        result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
        result2 = 31 * result2 + (this.version == null ? 0 : this.version.hashCode());
        return result2;
    }

    public Cookie setComment(String comment2) {
        this.comment = comment2;
        return this;
    }

    public Cookie setCommentURL(String commentURL) {
        this.commentURL = commentURL;
        return this;
    }

    public Cookie setDiscard(Boolean discard) {
        this.discard = discard;
        return this;
    }

    public Cookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Cookie setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    public Cookie setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public Cookie setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public Cookie setName(String name2) {
        this.name = name2;
        return this;
    }

    public Cookie setPath(String path2) {
        this.path = path2;
        return this;
    }

    public Cookie setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public Cookie setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    public Cookie setValue(String value2) {
        this.value = value2;
        return this;
    }

    public Cookie setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.name != null) {
            builder.append("name=").append(this.name).append(" ");
        }
        if (this.value != null) {
            builder.append("value=").append(this.value).append(" ");
        }
        if (this.comment != null) {
            builder.append("comment=").append(this.comment).append(" ");
        }
        if (this.commentURL != null) {
            builder.append("commentURL=").append(this.commentURL).append(" ");
        }
        if (this.discard != null) {
            builder.append("discard=").append(this.discard).append(" ");
        }
        if (this.domain != null) {
            builder.append("domain=").append(this.domain).append(" ");
        }
        if (this.expires != null) {
            builder.append("expires=").append(this.expires).append(" ");
        }
        if (this.httpOnly != null) {
            builder.append("httpOnly=").append(this.httpOnly).append(" ");
        }
        if (this.maxAge != null) {
            builder.append("maxAge=").append(this.maxAge).append(" ");
        }
        if (this.path != null) {
            builder.append("path=").append(this.path).append(" ");
        }
        if (this.port != null) {
            builder.append("port=").append(this.port).append(" ");
        }
        if (this.secure != null) {
            builder.append("secure=").append(this.secure).append(" ");
        }
        if (this.sameSite != null) {
            builder.append("sameSite=").append((Object)this.sameSite).append(" ");
        }
        if (this.version != null) {
            builder.append("version=").append(this.version);
        }
        builder.append("]");
        return builder.toString();
    }

    private static boolean objectsAreEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static enum SameSite {
        STRICT,
        LAX,
        NONE;


        public static SameSite parse(String value2) {
            try {
                return SameSite.valueOf(value2.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

