/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.util.MultiValueMap;
import org.forgerock.http.util.Uris;

public class Form
extends MultiValueMap<String, String> {
    public Form() {
        super(new LinkedHashMap());
    }

    @Deprecated
    public Form fromString(String s2) {
        return this.fromFormString(s2);
    }

    public Form fromFormString(String s2) {
        for (String param : s2.split("&")) {
            String[] nv = param.split("=", 2);
            if (nv.length != 2) continue;
            this.add(Uris.formDecodeParameterNameOrValue(nv[0]), Uris.formDecodeParameterNameOrValue(nv[1]));
        }
        return this;
    }

    public Form fromQueryString(String s2) {
        for (String param : s2.split("&")) {
            String[] nv = param.split("=", 2);
            if (nv[0].isEmpty()) continue;
            this.add(Uris.urlDecodeQueryParameterNameOrValue(nv[0]), nv.length == 1 ? null : Uris.urlDecodeQueryParameterNameOrValue(nv[1]));
        }
        return this;
    }

    @Deprecated
    public String toString() {
        return this.toFormString();
    }

    public String toFormString() {
        StringBuilder sb = new StringBuilder();
        for (String name2 : this.keySet()) {
            if (name2.isEmpty()) continue;
            for (String value2 : (List)this.get(name2)) {
                if (value2 == null) continue;
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(Uris.formEncodeParameterNameOrValue(name2)).append('=').append(Uris.formEncodeParameterNameOrValue(value2));
            }
        }
        return sb.toString();
    }

    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        for (String name2 : this.keySet()) {
            if (name2.isEmpty()) continue;
            for (String value2 : (List)this.get(name2)) {
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(Uris.urlEncodeQueryParameterNameOrValue(name2));
                if (value2 == null) continue;
                sb.append('=').append(Uris.urlEncodeQueryParameterNameOrValue(value2));
            }
        }
        return sb.toString();
    }

    public Form fromRequestQuery(Request request) {
        String query = request.getUri().getRawQuery();
        if (query != null) {
            this.fromQueryString(query);
        }
        return this;
    }

    public void toRequestQuery(Request request) {
        try {
            request.getUri().setRawQuery(this.toQueryString());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
    }

    public void appendRequestQuery(Request request) {
        String newQuery;
        String toAppend;
        StringBuilder sb = new StringBuilder();
        String uriQuery = request.getUri().getRawQuery();
        if (uriQuery != null && uriQuery.length() > 0) {
            sb.append(uriQuery);
        }
        if ((toAppend = this.toQueryString()) != null && toAppend.length() > 0) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(toAppend);
        }
        if ((newQuery = sb.toString()).length() == 0) {
            newQuery = null;
        }
        try {
            request.getUri().setRawQuery(newQuery);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
    }

    public Form fromRequestEntity(Request request) throws IOException {
        if (request != null && request.getEntity() != null && "application/x-www-form-urlencoded".equalsIgnoreCase(request.getHeaders().getFirst(ContentTypeHeader.class))) {
            this.fromFormString(request.getEntity().getString());
        }
        return this;
    }

    public void toRequestEntity(Request request) {
        String form = this.toFormString();
        request.setMethod("POST");
        request.getHeaders().put("Content-Type", (Object)"application/x-www-form-urlencoded");
        request.getHeaders().put("Content-Length", (Object)form.length());
        request.getEntity().setString(form);
    }
}

