/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.http.header.GenericHeader;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Header;

public class Headers
implements Map<String, Object> {
    private final Map<String, Header> headers = new TreeMap<String, Header>(String.CASE_INSENSITIVE_ORDER);

    public Headers() {
    }

    Headers(Headers headers) {
        for (Map.Entry<String, Header> entry : headers.asMapOfHeaders().entrySet()) {
            this.add(entry.getKey(), entry.getValue().getValues());
        }
    }

    @Override
    public Header get(Object key2) {
        return this.headers.get(key2);
    }

    public String getFirst(String key2) {
        Header header = this.headers.get(key2);
        return header == null ? null : header.getFirstValue();
    }

    public String getFirst(Class<? extends Header> key2) {
        Header header = this.headers.get(this.getHeaderName(key2));
        return header == null ? null : header.getFirstValue();
    }

    public <H extends Header> H get(Class<H> headerType) throws MalformedHeaderException {
        Header header = this.get(this.getHeaderName(headerType));
        if (header instanceof GenericHeader) {
            throw new MalformedHeaderException("Header value(s) are not well formed");
        }
        return (H)((Header)headerType.cast(header));
    }

    private <H extends Header> String getHeaderName(Class<H> headerType) {
        String headerName = HeaderFactory.HEADER_NAMES.get(headerType);
        if (headerName == null) {
            throw new IllegalArgumentException("Unknown header type: " + headerType);
        }
        return headerName;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m3) {
        for (Map.Entry<? extends String, ? extends Object> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Header put(String key2, Object value2) {
        if (value2 == null) {
            return this.remove(key2);
        }
        HeaderFactory<?> factory = HeaderFactory.FACTORIES.get(key2);
        if (value2 instanceof Header) {
            return this.putHeader(key2, (Header)value2, factory);
        }
        if (factory != null) {
            return this.putUsingFactory(key2, value2, factory);
        }
        return this.putGenericHeader(key2, value2);
    }

    private Header putGenericHeader(String key2, Object value2) {
        if (value2 instanceof String) {
            return this.putGenericString(key2, (String)value2);
        }
        if (value2 instanceof List) {
            return this.putGenericList(key2, (List)value2);
        }
        if (value2 instanceof Collection) {
            return this.putGenericList(key2, new ArrayList((Collection)value2));
        }
        if (value2.getClass().isArray()) {
            return this.putGenericList(key2, Arrays.asList((Object[])value2));
        }
        throw new IllegalArgumentException("Cannot put object for key '" + key2 + "': " + value2);
    }

    private Header putHeader(String key2, Header header, HeaderFactory<?> factory) {
        if (!this.hasAnyValue(header)) {
            return this.remove(key2);
        }
        if (HeaderFactory.HEADER_NAMES.containsValue(key2) && !HeaderFactory.HEADER_NAMES.get(header.getClass()).equals(key2)) {
            if (header instanceof GenericHeader) {
                return this.putUsingFactory(key2, header.getValues(), factory);
            }
            throw new IllegalArgumentException("Header object of incorrect type for header " + key2);
        }
        return this.headers.put(key2, header);
    }

    private boolean hasAnyValue(Header header) {
        boolean hasValue = false;
        for (String s2 : header.getValues()) {
            if (s2 == null) continue;
            hasValue = true;
            break;
        }
        return hasValue;
    }

    private Header putGenericList(String key2, List<?> value2) {
        if (value2.isEmpty()) {
            return this.remove(key2);
        }
        for (String string2 : value2) {
            if (string2 instanceof String) continue;
            throw new IllegalArgumentException("Collections must be of strings");
        }
        return this.headers.put(key2, new GenericHeader(key2, value2));
    }

    private Header putGenericString(String key2, String value2) {
        return this.headers.put(key2, new GenericHeader(key2, value2));
    }

    private Header putUsingFactory(String key2, Object value2, HeaderFactory<?> factory) {
        Object parsed;
        try {
            parsed = factory.parse((Object)value2);
        }
        catch (MalformedHeaderException e) {
            if (value2 instanceof Header) {
                value2 = ((Header)((Object)value2)).getValues();
            }
            return this.putGenericHeader(key2, value2);
        }
        if (parsed == null) {
            return this.remove(key2);
        }
        return this.headers.put(key2, (Header)parsed);
    }

    @Override
    public Header remove(Object key2) {
        return this.headers.remove(key2);
    }

    public Header put(Header header) {
        return this.put(header.getName(), (Object)header);
    }

    public void add(Header header) {
        this.add(header.getName(), header);
    }

    /*
     * WARNING - void declaration
     */
    public void add(String key2, Object value2) {
        ArrayList<String> values2;
        if (value2 == null) {
            return;
        }
        ArrayList<String> arrayList = values2 = this.containsKey(key2) ? new ArrayList<String>(this.get(key2).getValues()) : new ArrayList();
        if (value2 instanceof Header) {
            for (String string2 : ((Header)value2).getValues()) {
                this.addNonNullStringValue(values2, string2);
            }
        } else if (value2 instanceof String) {
            values2.add((String)value2);
        } else if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            for (String s3 : collection) {
                this.addNonNullStringValue(values2, s3);
            }
        } else if (value2.getClass().isArray()) {
            String[] array2;
            for (String s4 : array2 = (String[])value2) {
                this.addNonNullStringValue(values2, s4);
            }
        } else {
            throw new IllegalArgumentException("Cannot add values for key '" + key2 + "': " + value2);
        }
        if (values2.isEmpty()) {
            return;
        }
        HeaderFactory<?> factory = HeaderFactory.FACTORIES.get(key2);
        if (factory != null) {
            void var5_11;
            try {
                Object obj = factory.parse(values2);
            }
            catch (MalformedHeaderException e) {
                GenericHeader genericHeader = new GenericHeader(key2, values2);
            }
            if (var5_11 == null) {
                return;
            }
            this.headers.put(key2, (Header)var5_11);
        } else {
            this.headers.put(key2, new GenericHeader(key2, values2));
        }
    }

    private void addNonNullStringValue(List<String> values2, String s2) {
        if (s2 != null) {
            values2.add(s2);
        }
    }

    public void addAll(Map<? extends String, ? extends Object> map2) {
        for (Map.Entry<? extends String, ? extends Object> entry : map2.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.headers.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.headers.containsValue(value2);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.headers.entrySet();
    }

    public Map<String, Header> asMapOfHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> copyAsMultiMapOfStrings() {
        TreeMap<String, List<String>> result2 = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : this.headers.values()) {
            result2.put(header.getName(), new ArrayList<String>(header.getValues()));
        }
        return result2;
    }
}

