/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.http.header.CookieHeader;
import org.forgerock.http.protocol.Cookie;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.util.UnmodifiableCollection;

public class RequestCookies
extends AbstractMap<String, List<Cookie>>
implements Map<String, List<Cookie>>,
UnmodifiableCollection {
    private final Request request;

    public RequestCookies(Request request) {
        this.request = request;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.get(key2) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.cookies().containsValue(value2);
    }

    @Override
    public Set<Map.Entry<String, List<Cookie>>> entrySet() {
        return this.cookies().entrySet();
    }

    @Override
    public List<Cookie> get(Object key2) {
        ArrayList<Cookie> list2 = new ArrayList<Cookie>();
        if (key2 instanceof String) {
            String s2 = (String)key2;
            for (Cookie cookie : CookieHeader.valueOf(this.request).getCookies()) {
                if (!s2.equalsIgnoreCase(cookie.getName())) continue;
                list2.add(cookie);
            }
        }
        return list2.size() > 0 ? list2 : null;
    }

    @Override
    public boolean isEmpty() {
        return CookieHeader.valueOf(this.request).getCookies().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.cookies().keySet();
    }

    @Override
    public int size() {
        return CookieHeader.valueOf(this.request).getCookies().size();
    }

    @Override
    public String toString() {
        return this.cookies().toString();
    }

    @Override
    public Collection<List<Cookie>> values() {
        return this.cookies().values();
    }

    private Map<String, List<Cookie>> cookies() {
        TreeMap<String, List<Cookie>> cookies = new TreeMap<String, List<Cookie>>(String.CASE_INSENSITIVE_ORDER);
        for (Cookie cookie : CookieHeader.valueOf(this.request).getCookies()) {
            ArrayList<Cookie> list2 = (ArrayList<Cookie>)cookies.get(cookie.getName());
            if (list2 == null) {
                list2 = new ArrayList<Cookie>(1);
                cookies.put(cookie.getName(), list2);
            }
            list2.add(cookie);
        }
        return cookies;
    }
}

