/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.io.IOException;
import org.forgerock.http.protocol.MessageImpl;
import org.forgerock.http.protocol.Status;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;

public final class Response
extends MessageImpl<Response> {
    private Status status;
    private Exception cause;

    public static Promise<Response, NeverThrowsException> newResponsePromise(Response response) {
        return Promises.newResultPromise(response);
    }

    public static PromiseImpl<Response, NeverThrowsException> newResponsePromiseImpl() {
        return PromiseImpl.create();
    }

    public Response() {
    }

    public Response(Response response) throws IOException {
        super(response);
        this.status = response.status;
        this.cause = response.cause;
    }

    public Response(Status status2) {
        this.status = Reject.checkNotNull(status2);
    }

    public Status getStatus() {
        return this.status;
    }

    public Exception getCause() {
        return this.cause;
    }

    public Response setCause(Exception cause2) {
        this.cause = cause2;
        return this;
    }

    @Override
    public Response setEntity(Object o) {
        this.setEntity0(o);
        return this;
    }

    public Response setStatus(Status status2) {
        this.status = Reject.checkNotNull(status2);
        return this;
    }

    @Override
    public Response setVersion(String version) {
        this.setVersion0(version);
        return this;
    }
}

