/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class Responses {
    private static final AsyncFunction<Exception, Response, NeverThrowsException> INTERNAL_SERVER_ERROR_ASYNC_FUNC = new AsyncFunction<Exception, Response, NeverThrowsException>(){

        @Override
        public Promise<Response, NeverThrowsException> apply(Exception e) {
            return Promises.newResultPromise(Responses.newInternalServerError(e));
        }
    };
    private static final Function<NeverThrowsException, Object, Exception> NOOP_EXCEPTION_FUNC = new Function<NeverThrowsException, Object, Exception>(){

        @Override
        public Object apply(NeverThrowsException value2) throws Exception {
            throw new IllegalStateException("NeverThrowsException has been throw ?!");
        }
    };

    public static Response newInternalServerError() {
        return new Response(Status.INTERNAL_SERVER_ERROR);
    }

    public static Response newInternalServerError(Exception exception2) {
        return Responses.newInternalServerError().setCause(exception2);
    }

    public static Response newNotFound() {
        return new Response(Status.NOT_FOUND);
    }

    public static <V, E extends Exception> Function<NeverThrowsException, V, E> noopExceptionFunction() {
        return NOOP_EXCEPTION_FUNC;
    }

    public static <E extends Exception> Function<E, Response, NeverThrowsException> onExceptionInternalServerError() {
        return new Function<E, Response, NeverThrowsException>(){

            @Override
            public Response apply(E e) {
                return Responses.newInternalServerError(e);
            }
        };
    }

    public static <E extends Exception> AsyncFunction<E, Response, NeverThrowsException> internalServerError() {
        return INTERNAL_SERVER_ERROR_ASYNC_FUNC;
    }

    private Responses() {
    }
}

