/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.util.Paths;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;

class UriRouteMatcher
extends RouteMatcher<List<String>> {
    private final RoutingMode mode;
    private final Pattern regex;
    private final String uriTemplate;
    private final List<String> variables = new LinkedList<String>();

    UriRouteMatcher(RoutingMode mode2, String uriTemplate) {
        this.uriTemplate = uriTemplate;
        this.mode = mode2;
        this.regex = UriTemplateParser.createRegex(mode2, uriTemplate, this.variables);
    }

    @Override
    public final RouteMatch evaluate(Context context, List<String> pathElements) {
        Map<Object, Object> variableMap;
        String uri = Paths.joinPath(pathElements);
        Matcher matcher = this.regex.matcher(uri);
        if (!matcher.matches()) {
            return null;
        }
        switch (this.variables.size()) {
            case 0: {
                variableMap = Collections.emptyMap();
                break;
            }
            case 1: {
                variableMap = Collections.singletonMap(this.variables.get(0), Paths.urlDecode(matcher.group(2)));
                break;
            }
            default: {
                variableMap = new LinkedHashMap(this.variables.size());
                for (int i2 = 0; i2 < this.variables.size(); ++i2) {
                    variableMap.put(this.variables.get(i2), Paths.urlDecode(matcher.group(i2 + 2)));
                }
            }
        }
        String remaining = UriTemplateParser.removeLeadingSlash(uri.substring(matcher.end(1)));
        return new UriRouteMatch(matcher.group(1), remaining, variableMap, this.mode);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.mode == RoutingMode.EQUALS) {
            builder.append("equals(");
        } else {
            builder.append("startsWith(");
        }
        builder.append(this.uriTemplate);
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriRouteMatcher)) {
            return false;
        }
        UriRouteMatcher that = (UriRouteMatcher)o;
        if (this.mode != that.mode) {
            return false;
        }
        if (!this.regex.toString().equals(that.regex.toString())) {
            return false;
        }
        if (!this.uriTemplate.equals(that.uriTemplate)) {
            return false;
        }
        return this.variables.equals(that.variables);
    }

    @Override
    public String idFragment() {
        return "/" + this.uriTemplate;
    }

    @Override
    public <D> D transformApi(D descriptor, ApiProducer<D> producer) {
        return descriptor != null ? (D)producer.withPath(descriptor, this.uriTemplate) : null;
    }

    @Override
    public int hashCode() {
        int result2 = this.mode.hashCode();
        result2 = 31 * result2 + this.regex.toString().hashCode();
        result2 = 31 * result2 + this.uriTemplate.hashCode();
        result2 = 31 * result2 + this.variables.hashCode();
        return result2;
    }

    private static final class UriRouteMatch
    implements RouteMatch {
        private final String matched;
        private final String remaining;
        private final Map<String, String> variableMap;
        private final RoutingMode mode;

        private UriRouteMatch(String matched2, String remaining, Map<String, String> variableMap, RoutingMode mode2) {
            this.matched = matched2;
            this.remaining = remaining;
            this.variableMap = variableMap;
            this.mode = mode2;
        }

        @Override
        public boolean isBetterMatchThan(RouteMatch routeMatch) throws IncomparableRouteMatchException {
            if (routeMatch == null) {
                return true;
            }
            if (!(routeMatch instanceof UriRouteMatch)) {
                throw new IncomparableRouteMatchException(this, routeMatch);
            }
            UriRouteMatch result2 = (UriRouteMatch)routeMatch;
            if (!this.matched.equals(result2.matched)) {
                return this.matched.length() > result2.matched.length();
            }
            if (this.mode != result2.mode) {
                return this.mode == RoutingMode.EQUALS;
            }
            return this.variableMap.size() < result2.variableMap.size();
        }

        @Override
        public Context decorateContext(Context context) {
            return new UriRouterContext(context, this.matched, this.remaining, this.variableMap);
        }
    }

    private static final class UriTemplateParser {
        private UriTemplateParser() {
        }

        static Pattern createRegex(RoutingMode mode2, String uriTemplate, List<String> variables) {
            String t = UriTemplateParser.removeTrailingSlash(UriTemplateParser.removeLeadingSlash(uriTemplate));
            StringBuilder builder = new StringBuilder(t.length() + 8);
            boolean isInVariable = false;
            int elementStart = 0;
            builder.append('(');
            for (int i2 = 0; i2 < t.length(); ++i2) {
                char c = t.charAt(i2);
                if (isInVariable) {
                    if (c == '}') {
                        if (elementStart == i2) {
                            throw new IllegalArgumentException("URI template " + t + " contains zero-length template variable");
                        }
                        variables.add(t.substring(elementStart, i2));
                        builder.append("([^/]+)");
                        isInVariable = false;
                        elementStart = i2 + 1;
                        continue;
                    }
                    if (UriTemplateParser.isValidVariableCharacter(c)) continue;
                    throw new IllegalArgumentException("URI template " + t + " contains an illegal character " + c + " in a template variable");
                }
                if (c != '{') continue;
                builder.append(Pattern.quote(t.substring(elementStart, i2)));
                isInVariable = true;
                elementStart = i2 + 1;
            }
            if (isInVariable) {
                throw new IllegalArgumentException("URI template " + t + " contains a trailing unclosed variable");
            }
            builder.append(Pattern.quote(t.substring(elementStart)));
            builder.append(')');
            if (mode2 == RoutingMode.STARTS_WITH) {
                if (uriTemplate.isEmpty()) {
                    builder.append("((.*))?");
                } else {
                    builder.append("(/(.*))?");
                }
            }
            return Pattern.compile(builder.toString());
        }

        static String removeLeadingSlash(String resourceName) {
            if (resourceName.startsWith("/")) {
                return resourceName.substring(1);
            }
            return resourceName;
        }

        private static String removeTrailingSlash(String resourceName) {
            if (resourceName.endsWith("/")) {
                return resourceName.substring(0, resourceName.length() - 1);
            }
            return resourceName;
        }

        private static boolean isValidVariableCharacter(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
        }
    }
}

