/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Version[] DOT_ZERO_CACHE = new Version[10];
    private static final Pattern REGEX = Pattern.compile("(\\d+)(\\.(\\d+))?");
    private final int major;
    private final int minor;

    public static Version version(int major, int minor) {
        if (minor == 0 && major >= 0 && major < DOT_ZERO_CACHE.length) {
            return DOT_ZERO_CACHE[major];
        }
        return new Version(major, minor);
    }

    public static Version version(int major) {
        return Version.version(major, 0);
    }

    private Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static Version version(String s2) {
        Matcher matcher = REGEX.matcher(s2);
        if (matcher.matches()) {
            if (matcher.group(3) == null) {
                return Version.version(Integer.parseInt(matcher.group(1)));
            }
            return Version.version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(3)));
        }
        throw new IllegalArgumentException("Invalid version string " + s2);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.major, version.major) && Objects.equals(this.minor, version.minor);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    @Override
    public int compareTo(Version that) {
        if (this.major != that.major) {
            return this.major - that.major;
        }
        if (this.minor != that.minor) {
            return this.minor - that.minor;
        }
        return 0;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public boolean isCompatibleWith(Version that) {
        return that != null && this.major == that.major && this.minor >= that.minor;
    }

    static {
        for (int i2 = 0; i2 < DOT_ZERO_CACHE.length; ++i2) {
            Version.DOT_ZERO_CACHE[i2] = new Version(i2, 0);
        }
    }
}

