/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.servlet;

import com.google.inject.ConfigurationException;
import com.google.inject.ProvisionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.forgerock.guice.core.InjectorHolder;
import org.forgerock.http.HttpApplication;

enum HttpApplicationLoader {
    SERVICE_LOADER{

        @Override
        HttpApplication load(ServletConfig config) throws ServletException {
            ServiceLoader<HttpApplication> configurations = ServiceLoader.load(HttpApplication.class);
            Iterator<HttpApplication> iterator = configurations.iterator();
            if (!iterator.hasNext()) {
                throw new ServletException("No HttpApplication implementation registered.");
            }
            HttpApplication configuration = iterator.next();
            if (iterator.hasNext()) {
                ArrayList<Object> messageParams = new ArrayList<Object>();
                messageParams.add(iterator.next().getClass().getName());
                String message2 = "Multiple HttpApplication implementations registered.\n%d configurations found: %s";
                while (iterator.hasNext()) {
                    messageParams.add(iterator.next().getClass().getName());
                    message2 = message2 + ", %s";
                }
                messageParams.add(0, messageParams.size());
                throw new ServletException(String.format(message2, messageParams.toArray()));
            }
            return configuration;
        }
    }
    ,
    SERVLET_CONTEXT{
        private static final String APPLICATION_KEY_INIT_PARAM_NAME = "application-key";

        @Override
        HttpApplication load(ServletConfig config) throws ServletException {
            String applicationKey = config.getInitParameter(APPLICATION_KEY_INIT_PARAM_NAME);
            if (applicationKey == null) {
                throw new ServletException("No application-key init-param set.");
            }
            Object application = config.getServletContext().getAttribute(applicationKey);
            if (application == null) {
                throw new ServletException("No HttpApplication found for key: " + applicationKey);
            }
            if (!(application instanceof HttpApplication)) {
                throw new ServletException("Invalid type: " + applicationKey.getClass().getName() + ". Application MUST BE an instance of " + HttpApplication.class.getName());
            }
            return (HttpApplication)application;
        }
    }
    ,
    GUICE{

        @Override
        HttpApplication load(ServletConfig config) throws ServletException {
            return LazilyLinkGuice.load(config);
        }
    };


    abstract HttpApplication load(ServletConfig var1) throws ServletException;

    private static class LazilyLinkGuice {
        private LazilyLinkGuice() {
        }

        private static HttpApplication load(ServletConfig config) throws ServletException {
            String applicationClassName = config.getInitParameter("application-class");
            try {
                if (applicationClassName == null) {
                    return (HttpApplication)InjectorHolder.getInstance(HttpApplication.class);
                }
                return (HttpApplication)InjectorHolder.getInstance(Class.forName(applicationClassName).asSubclass(HttpApplication.class));
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Failed to find the Http Application class: " + applicationClassName, (Throwable)e);
            }
            catch (ConfigurationException | ProvisionException e) {
                throw new ServletException("Failed to load the Http Application class: " + applicationClassName, e);
            }
        }
    }
}

