/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.servlet;

import io.swagger.models.Swagger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.DescribedHttpApplication;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.filter.TransactionIdInboundFilter;
import org.forgerock.http.handler.DescribableHandler;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.servlet.HttpApplicationLoader;
import org.forgerock.http.servlet.Servlet2Adapter;
import org.forgerock.http.servlet.Servlet3Adapter;
import org.forgerock.http.servlet.ServletRoutingBase;
import org.forgerock.http.servlet.ServletSession;
import org.forgerock.http.servlet.ServletSynchronizer;
import org.forgerock.http.servlet.ServletVersionAdapter;
import org.forgerock.http.session.SessionContext;
import org.forgerock.http.util.CaseInsensitiveSet;
import org.forgerock.http.util.Uris;
import org.forgerock.services.context.AttributesContext;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.RequestAuditContext;
import org.forgerock.services.context.RootContext;
import org.forgerock.util.Factory;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpFrameworkServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(HttpFrameworkServlet.class);
    private static final long serialVersionUID = 3524182656424860912L;
    private static final String SERVLET_REQUEST_X509_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final CaseInsensitiveSet NON_ENTITY_METHODS = new CaseInsensitiveSet(Arrays.asList("GET", "HEAD", "TRACE"));
    public static final String ROUTING_BASE_INIT_PARAM_NAME = "routing-base";
    private ServletVersionAdapter adapter;
    private HttpApplication application;
    private Factory<Buffer> storage;
    private DescribableHandler handler;
    static DescribableHandler rootHandler;
    private ServletRoutingBase routingBase;

    public HttpFrameworkServlet() {
    }

    public HttpFrameworkServlet(HttpApplication application) {
        this.application = application;
    }

    public static DescribableHandler getRootHandler() {
        return rootHandler;
    }

    public void init() throws ServletException {
        this.adapter = this.getAdapter(this.getServletContext());
        this.routingBase = this.selectRoutingBase(this.getServletConfig());
        if (this.application == null) {
            HttpApplicationLoader applicationLoader = this.getApplicationLoader(this.getServletConfig());
            this.application = this.getApplication(applicationLoader, this.getServletConfig());
        }
        this.storage = this.application.getBufferFactory();
        if (this.storage == null) {
            File tmpDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
            this.storage = IO.newTemporaryStorage(tmpDir);
        }
        try {
            this.handler = Handlers.chainOf((Handler)Handlers.asDescribableHandler(this.application.start()), new TransactionIdInboundFilter());
            if (this.application instanceof DescribedHttpApplication) {
                ApiProducer<Swagger> apiProducer = ((DescribedHttpApplication)this.application).getApiProducer();
                this.handler.api(apiProducer);
            } else {
                rootHandler = this.handler;
            }
        }
        catch (HttpApplicationException e) {
            logger.error("Error while starting the application.", e);
            this.handler = Handlers.asDescribableHandler(Handlers.internalServerErrorHandler(e));
        }
    }

    private ServletVersionAdapter getAdapter(ServletContext servletContext) throws ServletException {
        switch (servletContext.getMajorVersion()) {
            case 1: {
                throw new ServletException("Unsupported Servlet version " + servletContext.getMajorVersion());
            }
            case 2: {
                return new Servlet2Adapter();
            }
        }
        return new Servlet3Adapter();
    }

    private ServletRoutingBase selectRoutingBase(ServletConfig servletConfig) throws ServletException {
        String routingModeParam = servletConfig.getInitParameter(ROUTING_BASE_INIT_PARAM_NAME);
        if (routingModeParam == null) {
            return ServletRoutingBase.SERVLET_PATH;
        }
        try {
            return ServletRoutingBase.valueOf(routingModeParam.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("Invalid routing mode: " + routingModeParam);
        }
    }

    private HttpApplicationLoader getApplicationLoader(ServletConfig config) throws ServletException {
        String applicationLoaderParam = config.getInitParameter("application-loader");
        if (applicationLoaderParam == null) {
            return HttpApplicationLoader.SERVICE_LOADER;
        }
        try {
            return HttpApplicationLoader.valueOf(applicationLoaderParam.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("Invalid HTTP application loader: " + applicationLoaderParam);
        }
    }

    private HttpApplication getApplication(HttpApplicationLoader applicationLoader, ServletConfig config) throws ServletException {
        return applicationLoader.load(config);
    }

    protected void service(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        UriRouterContext uriRouterContext;
        Request request;
        ServletSession session = new ServletSession(req);
        final SessionContext sessionContext = new SessionContext((Context)new RootContext(), session);
        try {
            request = this.createRequest(req);
            uriRouterContext = this.createRouterContext(sessionContext, req, request);
        }
        catch (URISyntaxException e) {
            Response response = new Response(Status.BAD_REQUEST);
            response.setEntity(e.getMessage());
            this.writeResponse(response, resp, sessionContext);
            return;
        }
        AttributesContext attributesContext = new AttributesContext(new RequestAuditContext(uriRouterContext));
        Enumeration attributeNames = req.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            attributesContext.getAttributes().put(attributeName, req.getAttribute(attributeName));
        }
        attributesContext.getAttributes().put(HttpServletRequest.class.getName(), req);
        attributesContext.getAttributes().put(HttpServletResponse.class.getName(), resp);
        ClientContext context = this.createClientContext(attributesContext, req);
        final ServletSynchronizer sync2 = this.adapter.createServletSynchronizer(req, resp);
        try {
            final Promise<Response, NeverThrowsException> promise = this.handler.handle(context, request).thenOnResult(new ResultHandler<Response>(){

                @Override
                public void handleResult(Response response) {
                    req.setAttribute(request.getClass().getName(), (Object)request);
                    req.setAttribute(response.getClass().getName(), (Object)response);
                    HttpFrameworkServlet.this.writeResponse(request, response, resp, sessionContext, sync2);
                }
            }).thenOnRuntimeException(new RuntimeExceptionHandler(){

                @Override
                public void handleRuntimeException(RuntimeException e) {
                    logger.error("RuntimeException caught", e);
                    HttpFrameworkServlet.this.writeResponse(request, Responses.newInternalServerError(), resp, sessionContext, sync2);
                }
            });
            sync2.setAsyncListener(new Runnable(){

                @Override
                public void run() {
                    promise.cancel(true);
                }
            });
        }
        catch (Throwable throwable) {
            logger.error("Throwable caught", throwable);
            this.writeResponse(request, Responses.newInternalServerError(), resp, sessionContext, sync2);
        }
        try {
            sync2.awaitIfNeeded();
        }
        catch (InterruptedException e) {
            throw new ServletException("Awaiting asynchronous request was interrupted.", (Throwable)e);
        }
    }

    private Request createRequest(HttpServletRequest req) throws IOException, URISyntaxException {
        Request request = new Request();
        request.setMethod(req.getMethod());
        request.setUri(Uris.createNonStrict(req.getScheme(), null, req.getServerName(), req.getServerPort(), req.getRequestURI(), req.getQueryString(), null));
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name2 = (String)e.nextElement();
            request.getHeaders().add(name2, Collections.list(req.getHeaders(name2)));
        }
        if (!(req.getContentLength() <= 0 && req.getHeader("Transfer-Encoding") == null || NON_ENTITY_METHODS.contains(request.getMethod()))) {
            request.setEntity(IO.newBranchingInputStream((InputStream)req.getInputStream(), this.storage));
        }
        return request;
    }

    private ClientContext createClientContext(Context parent, HttpServletRequest req) {
        return ClientContext.buildExternalClientContext(parent).remoteUser(req.getRemoteUser()).remoteAddress(req.getRemoteAddr()).remotePort(req.getRemotePort()).certificates((X509Certificate[])req.getAttribute(SERVLET_REQUEST_X509_ATTRIBUTE)).userAgent(req.getHeader("User-Agent")).secure("https".equalsIgnoreCase(req.getScheme())).localAddress(req.getLocalAddr()).localPort(req.getLocalPort()).build();
    }

    private UriRouterContext createRouterContext(Context parent, HttpServletRequest req, Request request) throws URISyntaxException {
        String matchedUri = this.routingBase.extractMatchedUri(req);
        String requestURI = req.getRequestURI();
        String remaining = requestURI.substring(requestURI.indexOf(matchedUri) + matchedUri.length());
        return UriRouterContext.uriRouterContext(parent).matchedUri(matchedUri).remainingUri(remaining).originalUri(request.getUri().asURI()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(Request request, Response response, HttpServletResponse servletResponse, SessionContext sessionContext, ServletSynchronizer synchronizer) {
        try {
            this.writeResponse(response, servletResponse, sessionContext);
        }
        catch (Throwable throwable) {
            Utils.closeSilently(request);
            synchronizer.signalAndComplete();
            throw throwable;
        }
        Utils.closeSilently(request);
        synchronizer.signalAndComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(Response response, HttpServletResponse servletResponse, SessionContext sessionContext) {
        block6: {
            try {
                if (response == null) break block6;
                servletResponse.setStatus(response.getStatus().getCode());
                sessionContext.getSession().save(response);
                for (String name2 : response.getHeaders().keySet()) {
                    for (String value2 : response.getHeaders().get(name2).getValues()) {
                        if (value2 == null || value2.length() <= 0) continue;
                        servletResponse.addHeader(name2, value2);
                    }
                }
                if (response.getEntity().isRawContentEmpty()) break block6;
                response.getEntity().copyRawContentTo((OutputStream)servletResponse.getOutputStream());
            }
            catch (IOException e) {
                try {
                    logger.error("Failed to write response", e);
                }
                catch (Throwable throwable) {
                    Utils.closeSilently(response);
                    throw throwable;
                }
                Utils.closeSilently(response);
            }
        }
        Utils.closeSilently(response);
    }

    public void destroy() {
        this.application.stop();
    }
}

