/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.servlet;

import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.http.servlet.ServletSynchronizer;
import org.forgerock.http.servlet.ServletVersionAdapter;

final class Servlet2Adapter
implements ServletVersionAdapter {
    Servlet2Adapter() {
    }

    @Override
    public ServletSynchronizer createServletSynchronizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return new Servlet2Synchronizer();
    }

    static final class Servlet2Synchronizer
    implements ServletSynchronizer {
        private final CountDownLatch requestCompletionLatch = new CountDownLatch(1);
        private Runnable listener;

        Servlet2Synchronizer() {
        }

        @Override
        public void setAsyncListener(Runnable runnable) {
            this.listener = runnable;
        }

        @Override
        public void awaitIfNeeded() throws InterruptedException {
            this.requestCompletionLatch.await();
            if (this.listener != null) {
                this.listener.run();
            }
        }

        @Override
        public void signalAndComplete() {
            this.requestCompletionLatch.countDown();
        }
    }
}

