/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.util.HashMap;
import java.util.Map;
import org.forgerock.util.MapDecorator;

public class CaseInsensitiveMap<V>
extends MapDecorator<String, V> {
    private final Map<String, String> lc = new HashMap<String, String>();

    public CaseInsensitiveMap() {
        super(new HashMap());
    }

    public CaseInsensitiveMap(Map<String, V> map2) {
        super(map2);
        this.sync();
    }

    private Object translate(Object key2) {
        String k;
        if (key2 instanceof String && (k = this.lc.get(((String)key2).toLowerCase())) != null) {
            key2 = k;
        }
        return key2;
    }

    public void sync() {
        this.lc.clear();
        for (String key2 : this.map.keySet()) {
            this.lc.put(key2.toLowerCase(), key2);
        }
    }

    @Override
    public void clear() {
        this.lc.clear();
        super.clear();
    }

    @Override
    public boolean containsKey(Object key2) {
        return super.containsKey(this.translate(key2));
    }

    @Override
    public V put(String key2, V value2) {
        V removed = this.remove(key2);
        this.lc.put(key2.toLowerCase(), key2);
        super.put(key2, value2);
        return removed;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m3) {
        for (String string2 : m3.keySet()) {
            this.put(string2, m3.get(string2));
        }
    }

    @Override
    public V get(Object key2) {
        return super.get(this.translate(key2));
    }

    @Override
    public V remove(Object key2) {
        Object removed = super.remove(this.translate(key2));
        if (key2 instanceof String) {
            this.lc.remove(((String)key2).toLowerCase());
        }
        return removed;
    }
}

