/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.http.util.SetDecorator;

public class CaseInsensitiveSet
extends SetDecorator<String> {
    private final Map<String, String> lc;

    public CaseInsensitiveSet() {
        super(new HashSet());
        this.lc = new HashMap<String, String>();
    }

    public CaseInsensitiveSet(Collection<String> c) {
        super(c instanceof Set ? (Set<Object>)c : new HashSet<String>(c));
        this.lc = new HashMap<String, String>(c.size());
        for (String e : c) {
            this.lc.put(e.toLowerCase(), e);
        }
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        super(new HashSet(initialCapacity, loadFactor));
        this.lc = new HashMap<String, String>(initialCapacity, loadFactor);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        super(new HashSet(initialCapacity));
        this.lc = new HashMap<String, String>(initialCapacity);
    }

    private Object translate(Object element) {
        String e;
        if (element instanceof String && (e = this.lc.get(((String)element).toLowerCase())) != null) {
            element = e;
        }
        return element;
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(this.translate(o));
    }

    @Override
    public boolean add(String e) {
        if (this.contains(e)) {
            return false;
        }
        this.lc.put(e.toLowerCase(), e);
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(this.translate(o));
        if (o instanceof String) {
            this.lc.remove(((String)o).toLowerCase());
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean changed = false;
        for (String string2 : c) {
            if (!this.add(string2)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (String e : this) {
            if (c.contains(e)) continue;
            this.remove(e);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (String e : this) {
            if (!c.contains(e)) continue;
            this.remove(e);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.lc.clear();
        super.clear();
    }
}

