/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.forgerock.http.util.Indexed;

public final class Loader {
    private Loader() {
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> getClass(String name2) {
        try {
            return Class.forName(name2, true, Loader.getClassLoader());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object newInstance(String name2) {
        try {
            return Loader.getClass(name2).newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static <T> T newInstance(String name2, Class<T> type2) {
        Object object = Loader.newInstance(name2);
        if (object != null && !type2.isInstance(object)) {
            object = null;
        }
        return (T)object;
    }

    public static <K, V extends Indexed<K>> Map<K, V> loadMap(Class<K> keyType, Class<V> serviceType) {
        HashMap map2 = new HashMap();
        for (Indexed v : ServiceLoader.load(serviceType, Loader.getClassLoader())) {
            map2.put(v.getKey(), v);
        }
        return map2;
    }

    public static <E> List<E> loadList(Class<E> serviceType) {
        ArrayList<E> list2 = new ArrayList<E>();
        for (E e : ServiceLoader.load(serviceType, Loader.getClassLoader())) {
            list2.add(e);
        }
        return list2;
    }

    public static URL getResource(String name2) {
        return Loader.getClassLoader().getResource(name2);
    }
}

