/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.forgerock.http.util.Uris;

public final class Paths {
    private static final Pattern PATH_SPLIT_PATTERN = Pattern.compile("/");

    public static String urlDecode(Object value2) {
        return Uris.urlDecodePathElement(value2.toString());
    }

    public static String urlEncode(Object value2) {
        return Uris.urlEncodePathElement(value2.toString());
    }

    public static List<String> getPathElements(String rawPath) {
        List elements;
        String[] pathElements = null;
        if (rawPath != null) {
            if (rawPath.startsWith("/")) {
                rawPath = rawPath.substring(1);
            }
            if ((pathElements = PATH_SPLIT_PATTERN.split(rawPath, -1)).length == 1 && pathElements[0].isEmpty()) {
                pathElements = null;
            }
        }
        if (pathElements == null) {
            elements = Collections.emptyList();
        } else {
            ArrayList decodedElements = new ArrayList(pathElements.length);
            for (String element : pathElements) {
                decodedElements.add(Paths.urlDecode(element));
            }
            elements = decodedElements;
        }
        return Collections.unmodifiableList(elements);
    }

    public static String joinPath(List<String> elements) {
        if (elements == null) {
            return "";
        }
        StringBuilder s2 = new StringBuilder();
        for (String element : elements) {
            if (s2.length() > 0) {
                s2.append("/");
            }
            s2.append(Paths.urlEncode(element));
        }
        return s2.toString();
    }

    public static String removeTrailingSlash(String path2) {
        return path2.endsWith("/") ? path2.substring(0, path2.length() - 1) : path2;
    }

    public static String addLeadingSlash(String path2) {
        return path2.startsWith("/") ? path2 : "/" + path2;
    }

    private Paths() {
    }
}

