/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n;

import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizableMessageDescriptor;

public final class LocalizableMessage
implements CharSequence,
Formattable,
Comparable<LocalizableMessage>,
Serializable {
    private static final long serialVersionUID = 8011606572832995899L;
    public static final LocalizableMessage EMPTY = LocalizableMessage.raw("", new Object[0]);
    private static final boolean IS_AIX_POST5 = LocalizableMessage.isAIXPost5();
    private final LocalizableMessageDescriptor.AbstractLocalizableMessageDescriptor descriptor;
    private final Object[] args;

    public static LocalizableMessage raw(CharSequence formatString, Object ... args2) {
        if (formatString == null) {
            throw new NullPointerException("formatString was null");
        }
        if (args2 == null || args2.length == 0) {
            return LocalizableMessageDescriptor.RAW0.get(formatString);
        }
        return new LocalizableMessageDescriptor.Raw(formatString).get(args2);
    }

    public static LocalizableMessage valueOf(Object object) {
        if (object instanceof LocalizableMessage) {
            return (LocalizableMessage)object;
        }
        if (object instanceof LocalizableMessageBuilder) {
            return ((LocalizableMessageBuilder)object).toMessage();
        }
        return LocalizableMessage.raw(String.valueOf(object), new Object[0]);
    }

    private static boolean isAIXPost5() {
        boolean isJDK15 = false;
        try {
            String javaRelease = System.getProperty("java.version");
            isJDK15 = javaRelease.startsWith("1.5");
        }
        catch (Throwable t) {
            System.err.println("Cannot get the java version: " + t);
        }
        boolean isAIX = "aix".equalsIgnoreCase(System.getProperty("os.name"));
        return !isJDK15 && isAIX;
    }

    LocalizableMessage(LocalizableMessageDescriptor.AbstractLocalizableMessageDescriptor descriptor, Object ... args2) {
        this.descriptor = descriptor;
        this.args = args2;
    }

    @Override
    public char charAt(int index2) {
        return this.charAt(Locale.getDefault(), index2);
    }

    public char charAt(Locale locale, int index2) {
        return this.toString(locale).charAt(index2);
    }

    @Override
    public int compareTo(LocalizableMessage message2) {
        return this.toString().compareTo(message2.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LocalizableMessage) {
            LocalizableMessage message2 = (LocalizableMessage)o;
            return this.toString().equals(message2.toString());
        }
        return false;
    }

    @Override
    public void formatTo(Formatter formatter, int flags2, int width, int precision) {
        Locale l = formatter.locale();
        formatter.format(l, this.descriptor.getFormatString(l), this.args);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int length() {
        return this.length(Locale.getDefault());
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public int ordinal() {
        return this.descriptor.ordinal();
    }

    public String resourceName() {
        return this.descriptor.resourceName();
    }

    @Override
    public CharSequence subSequence(int start2, int end2) {
        return this.subSequence(Locale.getDefault(), start2, end2);
    }

    public CharSequence subSequence(Locale locale, int start2, int end2) {
        return this.toString(locale).subSequence(start2, end2);
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        String s2;
        block10: {
            String fmt = this.descriptor.getFormatString(locale);
            if (this.descriptor.requiresFormatter()) {
                try {
                    if (IS_AIX_POST5) {
                        boolean changeType = false;
                        for (Object o : this.args) {
                            if (!(o instanceof Formattable)) continue;
                            changeType = true;
                            break;
                        }
                        if (changeType) {
                            Object[] newArgs = new Object[this.args.length];
                            for (int i2 = 0; i2 < this.args.length; ++i2) {
                                newArgs[i2] = this.args[i2] instanceof Formattable ? this.args[i2].toString() : this.args[i2];
                            }
                            s2 = new Formatter(locale).format(locale, fmt, newArgs).toString();
                        } else {
                            s2 = new Formatter(locale).format(locale, fmt, this.args).toString();
                        }
                        break block10;
                    }
                    s2 = new Formatter(locale).format(locale, fmt, this.args).toString();
                }
                catch (IllegalFormatException e) {
                    s2 = fmt;
                }
            } else {
                s2 = fmt;
            }
        }
        if (s2 == null) {
            s2 = "";
        }
        return s2;
    }
}

