/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.forgerock.i18n.LocalizableMessage;

public final class LocalizableMessageBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -3292823563904285315L;
    private final List<LocalizableMessage> messages = new LinkedList<LocalizableMessage>();

    public LocalizableMessageBuilder() {
    }

    public LocalizableMessageBuilder(LocalizableMessage message2) {
        this.append(message2);
    }

    public LocalizableMessageBuilder(LocalizableMessageBuilder builder) {
        for (LocalizableMessage message2 : builder.messages) {
            this.messages.add(message2);
        }
    }

    public LocalizableMessageBuilder(Object object) {
        this.append(object);
    }

    @Override
    public LocalizableMessageBuilder append(char c) {
        return this.append(LocalizableMessage.valueOf(Character.valueOf(c)));
    }

    @Override
    public LocalizableMessageBuilder append(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException("cs was null");
        }
        return this.append((Object)cs);
    }

    @Override
    public LocalizableMessageBuilder append(CharSequence cs, int start2, int end2) {
        return this.append(cs.subSequence(start2, end2));
    }

    public LocalizableMessageBuilder append(int value2) {
        return this.append(LocalizableMessage.valueOf(value2));
    }

    public LocalizableMessageBuilder append(LocalizableMessage message2) {
        if (message2 == null) {
            throw new NullPointerException("message was null");
        }
        this.messages.add(message2);
        return this;
    }

    public LocalizableMessageBuilder append(Object object) {
        return this.append(LocalizableMessage.valueOf(object));
    }

    @Override
    public char charAt(int index2) {
        return this.charAt(Locale.getDefault(), index2);
    }

    public char charAt(Locale locale, int index2) {
        return this.toString(locale).charAt(index2);
    }

    @Override
    public int length() {
        return this.length(Locale.getDefault());
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    @Override
    public CharSequence subSequence(int start2, int end2) {
        return this.subSequence(Locale.getDefault(), start2, end2);
    }

    public CharSequence subSequence(Locale locale, int start2, int end2) {
        return this.toString(locale).subSequence(start2, end2);
    }

    public LocalizableMessage toMessage() {
        if (this.messages.isEmpty()) {
            return LocalizableMessage.EMPTY;
        }
        int sz = this.messages.size();
        StringBuffer fmtString = new StringBuffer(sz * 2);
        for (int i2 = 0; i2 < sz; ++i2) {
            fmtString.append("%s");
        }
        return LocalizableMessage.raw(fmtString, this.messages.toArray());
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        StringBuilder builder = new StringBuilder();
        for (LocalizableMessage message2 : this.messages) {
            builder.append(message2.toString(locale));
        }
        return builder.toString();
    }
}

