/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPatchValueTransformer;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.util.Reject;

public final class JsonPatch {
    public static final String MEDIA_TYPE = "application/json-patch";
    public static final JsonPointer OP_PTR = new JsonPointer("/op");
    public static final JsonPointer PATH_PTR = new JsonPointer("/path");
    public static final JsonPointer FROM_PTR = new JsonPointer("/from");
    public static final JsonPointer VALUE_PTR = new JsonPointer("/value");
    private static final JsonPatchValueTransformer DEFAULT_TRANSFORM = new JsonPatchValueTransformer(){

        @Override
        public Object getTransformedValue(JsonValue target, JsonValue op) {
            if (op.get(VALUE_PTR) != null) {
                return op.get(VALUE_PTR).getObject();
            }
            throw new JsonValueException(op, "expecting a value member");
        }
    };

    public static JsonValue diff(JsonValue original, JsonValue target) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (JsonPatch.differentTypes(original, target)) {
            result2.add(JsonPatch.op("replace", original.getPointer(), target));
        } else if (original.isMap()) {
            for (String key2 : original.keys()) {
                if (target.isDefined(key2)) {
                    JsonValue diff = JsonPatch.diff(original.get(key2), target.get(key2));
                    if (diff.size() <= 0) continue;
                    result2.addAll(diff.asList());
                    continue;
                }
                result2.add(JsonPatch.op("remove", original.getPointer().child(key2), null));
            }
            for (String key2 : target.keys()) {
                if (original.isDefined(key2)) continue;
                result2.add(JsonPatch.op("add", original.getPointer().child(key2), target.get(key2)));
            }
        } else if (original.isList()) {
            boolean replace2 = false;
            if (original.size() != target.size()) {
                replace2 = true;
            } else {
                Iterator<JsonValue> i1 = original.iterator();
                Iterator<JsonValue> i2 = target.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    if (JsonPatch.diff(i1.next(), i2.next()).size() <= 0) continue;
                    replace2 = true;
                    break;
                }
            }
            if (replace2) {
                result2.add(JsonPatch.op("replace", original.getPointer(), target));
            }
        } else if (!original.isNull() && !original.getObject().equals(target.getObject())) {
            result2.add(JsonPatch.op("replace", original.getPointer(), target));
        }
        return new JsonValue(result2);
    }

    public static boolean isEqual(JsonValue value2, JsonValue other) {
        Reject.ifFalse(JsonPatch.isJsonPrimitive(value2) && JsonPatch.isJsonPrimitive(other), "JsonPatch#isEqual only supports recognizable JSON primitives");
        if (JsonPatch.differentTypes(value2, other)) {
            return false;
        }
        if (value2.size() != other.size()) {
            return false;
        }
        if (value2.isMap()) {
            for (String key2 : value2.keys()) {
                if (other.isDefined(key2) && JsonPatch.isEqual(value2.get(key2), other.get(key2))) continue;
                return false;
            }
        } else if (value2.isList()) {
            Iterator<JsonValue> i1 = value2.iterator();
            Iterator<JsonValue> i2 = other.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (JsonPatch.isEqual(i1.next(), i2.next())) continue;
                return false;
            }
        } else if (!value2.isNull() && !value2.getObject().equals(other.getObject())) {
            return false;
        }
        return true;
    }

    private static boolean isJsonPrimitive(JsonValue value2) {
        return value2.isNull() || value2.isBoolean() || value2.isMap() || value2.isList() || value2.isNumber() || value2.isString();
    }

    private static boolean differentTypes(JsonValue v1, JsonValue v2) {
        return !(v1.isNull() && v2.isNull() || v1.isMap() && v2.isMap() || v1.isList() && v2.isList() || v1.isString() && v2.isString() || v1.isNumber() && v2.isNumber() || v1.isBoolean() && v2.isBoolean());
    }

    private static HashMap<String, Object> op(String op, JsonPointer pointer2, JsonValue value2) {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put(OP_PTR.leaf(), op);
        result2.put(PATH_PTR.leaf(), pointer2.toString());
        if (value2 != null) {
            result2.put(VALUE_PTR.leaf(), value2.copy().getObject());
        }
        return result2;
    }

    public static void patch(JsonValue original, JsonValue patch) {
        JsonPatch.patch(original, patch, DEFAULT_TRANSFORM);
    }

    public static void patch(JsonValue original, JsonValue patch, JsonPatchValueTransformer transform) {
        for (JsonValue operation : patch.required().expect(List.class)) {
            if (!operation.isDefined("op")) {
                throw new JsonValueException(operation, "op not specified");
            }
            PatchOperation op = PatchOperation.valueOf(operation.get(OP_PTR));
            if (op == null) {
                throw new JsonValueException(operation, "invalid op specified");
            }
            op.execute(original, operation, transform);
        }
    }

    private static JsonValue parentValue(JsonPointer pointer2, JsonValue target) {
        JsonValue result2 = null;
        JsonPointer parent = pointer2.parent();
        if (parent != null && (result2 = target.get(parent)) == null) {
            throw new JsonException("parent value not found");
        }
        return result2;
    }

    private JsonPatch() {
    }

    private static enum PatchOperation {
        ADD{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer modifyPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue parent = JsonPatch.parentValue(modifyPath, original);
                if (parent == null) {
                    if (original.getObject() != null) {
                        throw new JsonValueException(operation, "root value already exists");
                    }
                    original.setObject(transform.getTransformedValue(original, operation));
                } else {
                    try {
                        if (parent.isList()) {
                            try {
                                Integer index2 = Integer.valueOf(modifyPath.leaf());
                                parent.add(index2, transform.getTransformedValue(original, operation));
                            }
                            catch (Exception exception2) {
                                parent.add(modifyPath.leaf(), transform.getTransformedValue(original, operation));
                            }
                        } else if (original.get(modifyPath) != null && original.get(modifyPath).isList()) {
                            JsonValue target = original.get(modifyPath);
                            target.asList().add(transform.getTransformedValue(original, operation));
                        } else {
                            parent.add(modifyPath.leaf(), transform.getTransformedValue(original, operation));
                        }
                    }
                    catch (JsonException je) {
                        throw new JsonValueException(operation, (Throwable)je);
                    }
                }
            }
        }
        ,
        REMOVE{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer modifyPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue parent = JsonPatch.parentValue(modifyPath, original);
                String leaf = modifyPath.leaf();
                if (parent == null) {
                    original.setObject(null);
                } else {
                    if (!parent.isDefined(leaf)) {
                        throw new JsonValueException(operation, "value to remove not found");
                    }
                    try {
                        parent.remove(leaf);
                    }
                    catch (JsonException je) {
                        throw new JsonValueException(operation, (Throwable)je);
                    }
                }
            }
        }
        ,
        REPLACE{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer modifyPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue parent = JsonPatch.parentValue(modifyPath, original);
                if (parent != null) {
                    String leaf = modifyPath.leaf();
                    if (!parent.isDefined(leaf)) {
                        throw new JsonValueException(operation, "value to replace not found");
                    }
                    parent.put(leaf, transform.getTransformedValue(original, operation));
                } else {
                    original.setObject(transform.getTransformedValue(original, operation));
                }
            }
        }
        ,
        MOVE{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer sourcePath = operation.get(FROM_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonPointer destPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue sourceParent = JsonPatch.parentValue(sourcePath, original);
                if (sourceParent == null) {
                    throw new JsonValueException(operation, "cannot move root object");
                }
                JsonValue object = sourceParent.get(sourcePath.leaf());
                JsonValue destParent = JsonPatch.parentValue(destPath, original);
                if (destParent == null) {
                    original.setObject(object);
                } else {
                    sourceParent.remove(sourcePath.leaf());
                    destParent.put(destPath.leaf(), (Object)object);
                }
            }
        }
        ,
        COPY{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonPointer sourcePath = operation.get(FROM_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonPointer destPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue sourceParent = JsonPatch.parentValue(sourcePath, original);
                JsonValue object = sourceParent.get(sourcePath.leaf());
                JsonValue destParent = JsonPatch.parentValue(destPath, original);
                if (destParent == null) {
                    original.setObject(object);
                } else {
                    destParent.put(destPath.leaf(), (Object)object);
                }
            }
        }
        ,
        TEST{

            @Override
            void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
                JsonValue testValue;
                JsonPointer testPath = operation.get(PATH_PTR).expect(String.class).as(JsonValueFunctions.pointer());
                JsonValue testTarget = JsonPatch.parentValue(testPath, original).get(testPath.leaf());
                if (JsonPatch.diff(testTarget, testValue = new JsonValue(transform.getTransformedValue(original, operation))).asList().size() > 0) {
                    throw new JsonValueException(operation, "test failed");
                }
            }
        };


        void execute(JsonValue original, JsonValue operation, JsonPatchValueTransformer transform) {
            throw new JsonValueException(original, "unsupported operation");
        }

        public static PatchOperation valueOf(String string2) {
            return Enum.valueOf(PatchOperation.class, string2);
        }
    }
}

