/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.math.BigDecimal;
import java.net.URI;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPatch;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.util.Function;
import org.forgerock.util.RangeSet;

public class JsonValue
implements Cloneable,
Iterable<JsonValue> {
    private Object object;
    private JsonPointer pointer;

    public static List<Object> array(Object ... objects) {
        return new ArrayList<Object>(Arrays.asList(objects));
    }

    public static List<Object> set(Object ... objects) {
        return new ArrayList<Object>(Arrays.asList(objects));
    }

    public static Map.Entry<String, Object> fieldIfNotNull(String key2, Object value2) {
        return value2 != null ? JsonValue.field(key2, value2) : null;
    }

    public static Map.Entry<String, Object> field(String key2, Object value2) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key2, value2);
    }

    public static JsonValue json(Object object) {
        return object instanceof JsonValue ? (JsonValue)object : new JsonValue(object);
    }

    @SafeVarargs
    public static Map<String, Object> object(Map.Entry<String, Object> ... fields2) {
        Map<String, Object> object = JsonValue.object(fields2.length);
        Map.Entry<String, Object>[] entryArray = fields2;
        int n = fields2.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<String, Object> field2 = entryArray[n2];
            if (field2 != null) {
                object.put(field2.getKey(), field2.getValue());
            }
            ++n2;
        }
        return object;
    }

    public static Map<String, Object> object(int size2) {
        return new LinkedHashMap<String, Object>(size2);
    }

    public static int toIndex(String key2) {
        if (key2 == null || key2.isEmpty()) {
            return -1;
        }
        int result2 = 0;
        int i2 = 0;
        while (i2 < key2.length()) {
            char c = key2.charAt(i2);
            if (c < '0' || c > '9') {
                return -1;
            }
            result2 = result2 * 10 + (c - 48);
            ++i2;
        }
        return result2;
    }

    public JsonValue(Object object) {
        this(object, null);
    }

    public JsonValue(Object object, JsonPointer pointer2) {
        this.object = object;
        this.pointer = pointer2;
        if (object instanceof JsonValue) {
            JsonValue jv = (JsonValue)object;
            this.object = jv.object;
            if (pointer2 == null) {
                this.pointer = jv.pointer;
            }
        }
        if (this.pointer == null) {
            this.pointer = new JsonPointer();
        }
    }

    public JsonValue add(int index2, Object object) {
        List<Object> list2 = this.required().asList();
        if (index2 < 0 || index2 > list2.size()) {
            throw new JsonValueException(this, "List index out of range: " + index2);
        }
        list2.add(index2, object);
        return this;
    }

    public JsonValue add(JsonPointer pointer2, Object object) {
        this.navigateToParentOf(pointer2).required().addToken(pointer2.leaf(), object);
        return this;
    }

    public JsonValue add(Object object) {
        if (this.isList()) {
            return this.add(this.size(), object);
        }
        throw new JsonValueException(this, "Expecting a List");
    }

    public JsonValue add(String key2, Object object) {
        if (this.isMap()) {
            Map<String, Object> map2 = this.asMap();
            if (map2.containsKey(key2)) {
                throw new JsonValueException(this, "Map key " + key2 + " already exists");
            }
            map2.put(key2, object);
        } else if (this.isList()) {
            this.add(JsonValue.toIndex(key2), object);
        } else {
            throw new JsonValueException(this, "Expecting a Map or List");
        }
        return this;
    }

    public JsonValue addPermissive(JsonPointer pointer2, Object object) {
        this.navigateToParentOfPermissive(pointer2).addToken(pointer2.leaf(), object);
        return this;
    }

    public Boolean asBoolean() {
        return this.object == null ? null : (Boolean)this.expect(Boolean.class).object;
    }

    public Double asDouble() {
        return this.object == null ? null : Double.valueOf(this.asNumber().doubleValue());
    }

    public Integer asInteger() {
        return this.object == null ? null : Integer.valueOf(this.asNumber().intValue());
    }

    public BigDecimal asBigDecimal() {
        return this.object == null ? null : BigDecimal.valueOf(this.asNumber().doubleValue());
    }

    public Collection<Object> asCollection() {
        return this.asCollection(Object.class);
    }

    public List<Object> asList() {
        return this.asList(Object.class);
    }

    public Set<Object> asSet() {
        return new HashSet<Object>(this.asCollection());
    }

    public <E> Set<E> asSet(Class<E> type2) {
        return new HashSet<E>(this.asCollection(type2));
    }

    public <E> Collection<E> asCollection(Class<E> type2) {
        if (this.object != null) {
            this.expect(Collection.class);
            if (type2 != Object.class) {
                Collection coll = (Collection)this.object;
                for (Object element : coll) {
                    if (element == null || type2.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a Collection of " + type2.getName() + " elements");
                }
            }
        }
        return (Collection)this.object;
    }

    public <E> List<E> asList(Class<E> type2) {
        if (this.object != null) {
            this.expect(List.class);
            if (type2 != Object.class) {
                List list2 = (List)this.object;
                for (Object element : list2) {
                    if (element == null || type2.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a List of " + type2.getName() + " elements");
                }
            }
        }
        return (List)this.object;
    }

    public <V, E extends Exception> V as(Function<JsonValue, V, E> transformFunction) throws E {
        return transformFunction.apply(this);
    }

    public Long asLong() {
        return this.object == null ? null : Long.valueOf(this.asNumber().longValue());
    }

    public Map<String, Object> asMap() {
        return this.object == null ? null : (Map)this.expect(Map.class).object;
    }

    @Deprecated
    public <T extends Enum<T>> T asEnum(Class<T> type2) {
        return (T)((Enum)this.as(JsonValueFunctions.enumConstant(type2)));
    }

    public <V> Map<String, V> asMap(Class<V> type2) {
        if (this.object != null) {
            this.expect(Map.class);
            if (type2 != Object.class) {
                Map map2 = (Map)this.object;
                for (Object element : map2.values()) {
                    if (element == null || type2.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a Map of " + type2.getName() + " elements");
                }
            }
        }
        return (Map)this.object;
    }

    public <E> Map<String, List<E>> asMapOfList(Class<E> elementType) {
        if (this.object != null) {
            this.expect(Map.class);
            if (elementType != Object.class) {
                Map map2 = (Map)this.object;
                for (Object value2 : map2.values()) {
                    if (value2 != null && !(value2 instanceof List)) {
                        throw new JsonValueException(this, "Expecting a Map of List values");
                    }
                    List list2 = (List)value2;
                    for (Object element : list2) {
                        if (element == null || elementType.isInstance(element)) continue;
                        throw new JsonValueException(this, "Expecting a Map of Lists with " + elementType.getName() + " elements");
                    }
                }
            }
        }
        return (Map)this.object;
    }

    public Number asNumber() {
        return this.object == null ? (Number)null : (Number)((Number)this.expect(Number.class).object);
    }

    public String asString() {
        return this.object == null ? null : (String)this.expect(String.class).object;
    }

    public void clear() {
        if (this.isMap()) {
            this.asMap().clear();
        } else if (this.isCollection()) {
            this.asCollection().clear();
        }
    }

    public JsonValue clone() {
        JsonValue result2 = new JsonValue(this.object, this.pointer);
        if (this.isMap()) {
            result2.object = new LinkedHashMap<String, Object>(this.asMap());
        } else if (this.isList()) {
            result2.object = new ArrayList<Object>(this.asList());
        }
        return result2;
    }

    public boolean contains(Object object) {
        boolean result2 = false;
        if (this.isMap()) {
            result2 = this.asMap().containsValue(object);
        } else if (this.isCollection()) {
            result2 = this.asCollection().contains(object);
        }
        return result2;
    }

    public JsonValue copy() {
        JsonValue result2 = new JsonValue(this.object, this.pointer);
        if (this.isMap()) {
            Map<String, Object> map2 = JsonValue.object(this.size());
            for (String key2 : this.keys()) {
                map2.put(key2, this.get(key2).copy().getObject());
            }
            result2.object = map2;
        } else if (this.isList()) {
            ArrayList<Object> list2 = new ArrayList<Object>(this.size());
            for (JsonValue element : this) {
                list2.add(element.copy().getObject());
            }
            result2.object = list2;
        }
        return result2;
    }

    public JsonValue defaultTo(Object object) {
        return this.object != null ? this : new JsonValue(object, this.pointer);
    }

    public JsonValue expect(Class<?> type2) {
        if (this.object != null && !type2.isInstance(this.object)) {
            throw new JsonValueException(this, "Expecting a " + type2.getName());
        }
        return this;
    }

    public JsonValue get(int index2) {
        List<Object> list2;
        Object result2 = null;
        if (index2 < 0) {
            throw new JsonValueException(this, "List index out of range: " + index2);
        }
        if (this.isList() && index2 >= 0 && index2 < (list2 = this.asList()).size()) {
            result2 = list2.get(index2);
        }
        return new JsonValue(result2, this.pointer.child(index2));
    }

    public JsonValue get(JsonPointer pointer2) {
        JsonValue result2 = this;
        for (String token : pointer2) {
            JsonValue member = result2.get(token);
            if (member.isNull() && !result2.isDefined(token)) {
                return null;
            }
            result2 = member;
        }
        return result2;
    }

    public JsonValue get(String key2) {
        Object result2 = null;
        if (this.isMap()) {
            result2 = this.asMap().get(key2);
        } else if (this.isList()) {
            List<Object> list2 = this.asList();
            int index2 = JsonValue.toIndex(key2);
            if (index2 >= 0 && index2 < list2.size()) {
                result2 = list2.get(index2);
            }
        }
        return new JsonValue(result2, this.pointer.child(key2));
    }

    public Object getObject() {
        return this.object;
    }

    public JsonPointer getPointer() {
        return this.pointer;
    }

    public boolean isBoolean() {
        return this.object != null && this.object instanceof Boolean;
    }

    public boolean isDefined(String key2) {
        boolean result2 = false;
        if (this.isMap()) {
            result2 = this.asMap().containsKey(key2);
        } else if (this.isList()) {
            int index2 = JsonValue.toIndex(key2);
            result2 = index2 >= 0 && index2 < this.asList().size();
        }
        return result2;
    }

    public boolean isSet() {
        return this.isCollection();
    }

    public boolean isCollection() {
        return this.object instanceof Collection;
    }

    public boolean isList() {
        return this.object instanceof List;
    }

    public boolean isMap() {
        return this.object instanceof Map;
    }

    public boolean isNull() {
        return this.object == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean isNumber() {
        return this.object != null && this.object instanceof Number;
    }

    public boolean isString() {
        return this.object != null && this.object instanceof String;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        if (this.isList()) {
            return new Iterator<JsonValue>(){
                int cursor = 0;
                Iterator<Object> i;
                {
                    this.i = JsonValue.this.asList().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public JsonValue next() {
                    Object element = this.i.next();
                    return new JsonValue(element, JsonValue.this.pointer.child(this.cursor++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<JsonValue>(){
            Iterator<String> i;
            {
                this.i = JsonValue.this.keys().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public JsonValue next() {
                return JsonValue.this.get(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<String> keys() {
        if (this.isMap()) {
            return this.asMap().keySet();
        }
        if (this.isList()) {
            return new AbstractSet<String>(){
                final RangeSet range;
                {
                    this.range = new RangeSet(JsonValue.this.size());
                }

                @Override
                public boolean contains(Object o) {
                    boolean result2 = false;
                    if (o instanceof String) {
                        try {
                            result2 = this.range.contains(Integer.valueOf((String)o));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    return result2;
                }

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Integer> i;
                        {
                            this.i = range.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().toString();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.range.size();
                }
            };
        }
        return Collections.emptySet();
    }

    public JsonValue put(int index2, Object object) {
        List<Object> list2 = this.required().asList();
        if (index2 < 0 || index2 > list2.size()) {
            throw new JsonValueException(this, "List index out of range: " + index2);
        }
        if (index2 == list2.size()) {
            list2.add(object);
        } else {
            list2.set(index2, object);
        }
        return this;
    }

    public JsonValue put(JsonPointer pointer2, Object object) {
        this.navigateToParentOf(pointer2).required().putToken(pointer2.leaf(), object);
        return this;
    }

    public JsonValue put(String key2, Object object) {
        if (key2 == null) {
            throw new NullPointerException();
        }
        if (this.isMap()) {
            this.asMap().put(key2, object);
        } else if (this.isList()) {
            this.put(JsonValue.toIndex(key2), object);
        } else {
            throw new JsonValueException(this, "Expecting a Map or List");
        }
        return this;
    }

    public JsonValue putPermissive(JsonPointer pointer2, Object object) {
        this.navigateToParentOfPermissive(pointer2).putToken(pointer2.leaf(), object);
        return this;
    }

    public void remove(int index2) {
        List<Object> list2;
        if (index2 >= 0 && this.isList() && index2 < (list2 = this.asList()).size()) {
            list2.remove(index2);
        }
    }

    public void remove(JsonPointer pointer2) {
        this.navigateToParentOf(pointer2).remove(pointer2.leaf());
    }

    public void remove(String key2) {
        if (this.isMap()) {
            this.asMap().remove(key2);
        } else if (this.isList()) {
            this.remove(JsonValue.toIndex(key2));
        }
    }

    public JsonValue required() {
        if (this.object == null) {
            throw new JsonValueException(this, "Expecting a value");
        }
        return this;
    }

    public void setObject(Object object) {
        this.object = object;
        if (object instanceof JsonValue) {
            JsonValue jv = (JsonValue)object;
            this.object = jv.object;
        }
    }

    public int size() {
        if (this.isMap()) {
            return this.asMap().size();
        }
        if (this.isCollection()) {
            return this.asCollection().size();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNull()) {
            sb.append("null");
        } else if (this.isMap()) {
            sb.append("{ ");
            Map map2 = (Map)this.object;
            Iterator i2 = map2.keySet().iterator();
            while (i2.hasNext()) {
                Object key2 = i2.next();
                sb.append('\"');
                JsonValue.appendEscapedString(sb, key2.toString());
                sb.append("\": ");
                sb.append(new JsonValue(map2.get(key2)).toString());
                if (!i2.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" }");
        } else if (this.isCollection()) {
            sb.append("[ ");
            Iterator i3 = ((Collection)this.object).iterator();
            while (i3.hasNext()) {
                sb.append(new JsonValue(i3.next()).toString());
                if (!i3.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
        } else if (this.isString()) {
            sb.append('\"');
            JsonValue.appendEscapedString(sb, this.object.toString());
            sb.append('\"');
        } else {
            sb.append(this.object.toString());
        }
        return sb.toString();
    }

    private static void appendEscapedString(StringBuilder sb, String s2) {
        int size2 = s2.length();
        int i2 = 0;
        while (i2 < size2) {
            char c = s2.charAt(i2);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        String hex2 = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
                        int hexPadding = 4 - hex2.length();
                        sb.append("\\u");
                        int j = 0;
                        while (j < hexPadding) {
                            sb.append('0');
                            ++j;
                        }
                        sb.append(hex2);
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i2;
        }
    }

    private void addToken(String token, Object object) {
        if (this.isEndOfListToken(token) && this.isList()) {
            this.add(object);
        } else {
            this.add(token, object);
        }
    }

    private boolean isEndOfListToken(String token) {
        return token.equals("-");
    }

    private boolean isIndexToken(String token) {
        if (token.isEmpty()) {
            return false;
        }
        int i2 = 0;
        while (i2 < token.length()) {
            char c = token.charAt(i2);
            if (!Character.isDigit(c)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private JsonValue navigateToParentOf(JsonPointer pointer2) {
        JsonValue jv = this;
        int size2 = pointer2.size();
        int n = 0;
        while (n < size2 - 1) {
            if ((jv = jv.get(pointer2.get(n))).isNull()) break;
            ++n;
        }
        return jv;
    }

    private JsonValue navigateToParentOfPermissive(JsonPointer pointer2) {
        JsonValue jv = this;
        int size2 = pointer2.size();
        int n = 0;
        while (n < size2 - 1) {
            String token = pointer2.get(n);
            JsonValue next2 = jv.get(token);
            if (next2.isNotNull()) {
                jv = next2;
            } else {
                if (this.isIndexToken(token)) {
                    throw new JsonValueException(this, "Expecting a value");
                }
                String nextToken = pointer2.get(n + 1);
                if (this.isEndOfListToken(nextToken)) {
                    jv.add(token, new ArrayList());
                    jv = jv.get(token);
                } else {
                    if (this.isIndexToken(nextToken)) {
                        throw new JsonValueException(this, "Expecting a value");
                    }
                    jv.add(token, new LinkedHashMap());
                    jv = jv.get(token);
                }
            }
            ++n;
        }
        return jv;
    }

    private void putToken(String token, Object object) {
        if (this.isEndOfListToken(token) && this.isList()) {
            this.add(object);
        } else {
            this.put(token, object);
        }
    }

    public boolean isEqualTo(JsonValue other) {
        return JsonPatch.isEqual(this, other);
    }

    public JsonValue diff(JsonValue target) {
        return JsonPatch.diff(this, target);
    }

    public void patch(JsonValue patch) {
        JsonPatch.patch(this, patch);
    }

    @Deprecated
    public URI asURI() {
        return this.as(JsonValueFunctions.uri());
    }
}

