/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.util.Function;

public class JsonValueTraverseFunction
implements Function<JsonValue, JsonValue, JsonValueException> {
    private Function<JsonValue, ?, JsonValueException> transform;

    public JsonValueTraverseFunction(Function<JsonValue, ?, JsonValueException> transform) {
        this.transform = transform;
    }

    @Override
    public final JsonValue apply(JsonValue value2) {
        return new JsonValue(this.traverse(value2), value2.getPointer());
    }

    private Object traverse(JsonValue value2) {
        if (value2.isList()) {
            return this.traverseList(value2);
        }
        if (value2.isMap()) {
            return this.traverseMap(value2);
        }
        return value2.as(this.transform);
    }

    protected Object traverseList(JsonValue value2) {
        List<Object> result2 = JsonValue.array(new Object[0]);
        for (JsonValue elem : value2) {
            result2.add(this.apply(elem).getObject());
        }
        return result2;
    }

    protected Object traverseMap(JsonValue value2) {
        Map<String, Object> result2 = JsonValue.object(value2.size());
        for (String key2 : value2.keys()) {
            result2.put(key2, this.apply(value2.get(key2)).getObject());
        }
        return result2;
    }
}

