/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;

public class AdviceContext
extends AbstractContext {
    private static final String ADVICE_ATTR = "advice";
    private static final String RESTRICTED_ADVICE_NAMES_ATTR = "restrictedAdviceNames";
    private static final Pattern ALLOWED_RFC_CHARACTERS = Pattern.compile("^[\\x20-\\x7E]*$");
    private final Collection<String> restrictedAdviceNames = new HashSet<String>();
    private final Map<String, List<String>> advice = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

    public AdviceContext(Context parent, Collection<String> restrictedAdviceNames) {
        super(parent, ADVICE_ATTR);
        this.restrictedAdviceNames.addAll(restrictedAdviceNames);
        this.data.put(RESTRICTED_ADVICE_NAMES_ATTR, restrictedAdviceNames);
        this.data.put(ADVICE_ATTR, this.advice);
    }

    public AdviceContext(JsonValue savedContext, ClassLoader classLoader) {
        super(savedContext, classLoader);
        this.restrictedAdviceNames.addAll((Collection<String>)this.data.get(RESTRICTED_ADVICE_NAMES_ATTR).as(JsonValueFunctions.setOf(String.class)));
        this.advice.putAll(this.data.get(ADVICE_ATTR).asMapOfList(String.class));
    }

    public Map<String, List<String>> getAdvices() {
        return this.advice;
    }

    public void putAdvice(String adviceName, String ... advices) {
        Reject.ifNull(adviceName, advices);
        Reject.ifTrue(this.isRestrictedAdvice(adviceName), "Illegal use of restricted advice name, " + adviceName);
        for (String adviceEntry : advices) {
            Reject.ifTrue(!this.isRfcCompliant(adviceEntry), "Advice contains illegal characters in, " + adviceEntry);
        }
        List<String> adviceEntry = this.advice.get(adviceName);
        if (adviceEntry == null) {
            adviceEntry = new ArrayList<String>();
            this.advice.put(adviceName, adviceEntry);
        }
        adviceEntry.addAll(Arrays.asList(advices));
    }

    private boolean isRfcCompliant(String advice) {
        return ALLOWED_RFC_CHARACTERS.matcher(advice).matches();
    }

    private boolean isRestrictedAdvice(String adviceName) {
        return this.restrictedAdviceNames.contains(adviceName);
    }
}

