/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.http.header.HeaderUtil;
import org.forgerock.util.Reject;

public final class AdviceWarning {
    public static final int NOT_PRESENT = 100;
    public static final int RESPONSE_STALE = 110;
    public static final int REVALIDATION_FAILED = 111;
    public static final int DISCONNECTED_OPERATION = 112;
    public static final int HEURISTIC_EXPIRATION = 113;
    public static final int MISCELLANEOUS_WARNING = 199;
    public static final int TRANFORMATION_APPLIED = 214;
    public static final int MISCELLANEOUS_PERSISTENT_WARNING = 299;
    private final int warningCode;
    private final String warningAgent;
    private final String warningText;

    private AdviceWarning(Builder builder) {
        Reject.ifNull(builder.warningAgent, builder.warningText);
        this.warningCode = builder.warningCode;
        this.warningAgent = builder.warningAgent;
        this.warningText = builder.warningText;
    }

    public String toString() {
        return String.valueOf(this.warningCode) + " " + this.warningAgent + " " + HeaderUtil.quote(this.warningText);
    }

    public static AdviceWarning getNotPresent(String agentName, String missingKey) {
        return AdviceWarning.newBuilder().withWarningAgent(agentName).withWarningCode(100).withWarningText(missingKey + " should be included in the request.").build();
    }

    public static AdviceWarning newAdviceWarning(String agentName, String fmt, Object ... args2) {
        return AdviceWarning.newBuilder().withWarningAgent(agentName).withWarningCode(100).withWarningText(String.format(fmt, args2)).build();
    }

    private static Builder newBuilder() {
        return new Builder();
    }

    private static final class Builder {
        private int warningCode;
        private String warningAgent;
        private String warningText;

        private Builder() {
        }

        private Builder withWarningCode(int warningCode) {
            Reject.ifTrue(warningCode < 0);
            Reject.ifTrue(String.valueOf(warningCode).length() != 3);
            this.warningCode = warningCode;
            return this;
        }

        private Builder withWarningAgent(String warningAgent) {
            Reject.ifNull(warningAgent);
            Reject.ifTrue(warningAgent.isEmpty());
            this.warningAgent = warningAgent;
            return this;
        }

        private Builder withWarningText(String warningText) {
            Reject.ifNull(warningText);
            Reject.ifTrue(warningText.isEmpty());
            this.warningText = warningText;
            return this;
        }

        private AdviceWarning build() {
            return new AdviceWarning(this);
        }
    }
}

