/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.forgerock.api.annotations.Action;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

class AnnotatedActionMethods {
    private Map<String, AnnotatedMethod> methods = new HashMap<String, AnnotatedMethod>();

    AnnotatedActionMethods() {
    }

    Promise<ActionResponse, ResourceException> invoke(Context context, ActionRequest request) {
        return this.invoke(context, request, null);
    }

    Promise<ActionResponse, ResourceException> invoke(Context context, ActionRequest request, String id2) {
        AnnotatedMethod method2 = this.methods.get(request.getAction());
        if (method2 == null) {
            return new NotSupportedException(request.getAction() + "not supported").asPromise();
        }
        return method2.invoke(context, (Request)request, id2);
    }

    static AnnotatedActionMethods findAll(Object requestHandler, boolean needsId) {
        AnnotatedActionMethods methods2 = new AnnotatedActionMethods();
        for (Method method2 : requestHandler.getClass().getMethods()) {
            AnnotatedMethod checked;
            Action action = method2.getAnnotation(Action.class);
            if (action == null || (checked = AnnotatedMethod.checkMethod(Action.class, requestHandler, method2, needsId)) == null) continue;
            String actionName = action.name();
            if (actionName == null || actionName.length() == 0) {
                actionName = method2.getName();
            }
            methods2.methods.put(actionName, checked);
        }
        return methods2;
    }
}

