/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.forgerock.api.annotations.Create;
import org.forgerock.api.annotations.Patch;
import org.forgerock.api.annotations.Query;
import org.forgerock.api.annotations.Update;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

final class AnnotatedMethod {
    private final Object requestHandler;
    private final Method method;
    private final int idParameter;
    private final int contextParameter;
    private final int requestParameter;
    private final int queryHandlerParameter;
    private final int numberOfParameters;
    private final String operation;

    AnnotatedMethod(String operation, Object requestHandler, Method method2, int idParameter, int contextParameter, int requestParameter, int queryHandlerParameter, int numberOfParameters) {
        this.operation = operation;
        this.requestHandler = requestHandler;
        this.method = method2;
        this.idParameter = idParameter;
        this.contextParameter = contextParameter;
        this.requestParameter = requestParameter;
        this.queryHandlerParameter = queryHandlerParameter;
        this.numberOfParameters = numberOfParameters;
    }

    <T> Promise<T, ResourceException> invoke(Context context, Request request) {
        return this.invoke(context, request, null, null);
    }

    <T> Promise<T, ResourceException> invoke(Context context, Request request, String id2) {
        return this.invoke(context, request, null, id2);
    }

    <T> Promise<T, ResourceException> invoke(Context context, Request request, QueryResourceHandler queryHandler) {
        return this.invoke(context, request, queryHandler, null);
    }

    <T> Promise<T, ResourceException> invoke(Context context, Request request, QueryResourceHandler queryHandler, String id2) {
        if (this.method == null) {
            return new NotSupportedException(this.operation + " not supported").asPromise();
        }
        Object[] args2 = new Object[this.numberOfParameters];
        if (this.idParameter > -1) {
            args2[this.idParameter] = id2;
        }
        if (this.requestParameter > -1) {
            args2[this.requestParameter] = request;
        }
        if (this.contextParameter > -1) {
            args2[this.contextParameter] = context;
        }
        if (this.queryHandlerParameter > -1) {
            args2[this.queryHandlerParameter] = queryHandler;
        }
        try {
            return (Promise)this.method.invoke(this.requestHandler, args2);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access the annotated method: " + this.method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception from invocation expected to be handled by promise", e);
        }
    }

    static AnnotatedMethod findMethod(Object requestHandler, Class<? extends Annotation> annotation2, boolean needsId) {
        AnnotatedMethod checked;
        for (Method method2 : requestHandler.getClass().getMethods()) {
            if (method2.getAnnotation(annotation2) == null || (checked = AnnotatedMethod.checkMethod(annotation2, requestHandler, method2, needsId)) == null) continue;
            return checked;
        }
        for (Method method2 : requestHandler.getClass().getMethods()) {
            if (!method2.getName().equals(annotation2.getSimpleName().toLowerCase()) || (checked = AnnotatedMethod.checkMethod(annotation2, requestHandler, method2, needsId)) == null) continue;
            return checked;
        }
        return new AnnotatedMethod(annotation2.getSimpleName(), null, null, -1, -1, -1, -1, -1);
    }

    static AnnotatedMethod checkMethod(Class<?> annotation2, Object requestHandler, Method method2, boolean needsId) {
        if (Promise.class.equals(method2.getReturnType())) {
            int idParam = -1;
            int contextParam = -1;
            int requestParam = -1;
            int queryHandlerParam = -1;
            for (int i2 = 0; i2 < method2.getParameterTypes().length; ++i2) {
                Class<QueryResourceHandler> type2 = method2.getParameterTypes()[i2];
                if (String.class.equals(type2)) {
                    idParam = i2;
                    continue;
                }
                if (Context.class.equals(type2)) {
                    contextParam = i2;
                    continue;
                }
                if (Request.class.isAssignableFrom(type2)) {
                    requestParam = i2;
                    continue;
                }
                if (!type2.isAssignableFrom(QueryResourceHandler.class)) continue;
                queryHandlerParam = i2;
            }
            if (Arrays.asList(Create.class, Update.class, Patch.class, Query.class).contains(annotation2) && requestParam == -1) {
                return null;
            }
            if (queryHandlerParam == -1 && Query.class.equals(annotation2) || queryHandlerParam != -1 && !Query.class.equals(annotation2)) {
                return null;
            }
            if (!needsId || idParam > -1) {
                return new AnnotatedMethod(annotation2.getSimpleName(), requestHandler, method2, idParam, contextParam, requestParam, queryHandlerParam, method2.getParameterTypes().length);
            }
        }
        return null;
    }
}

