/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.api.annotations.Create;
import org.forgerock.api.annotations.Delete;
import org.forgerock.api.annotations.Patch;
import org.forgerock.api.annotations.Query;
import org.forgerock.api.annotations.Read;
import org.forgerock.api.annotations.Update;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedActionMethods;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.Promise;

class AnnotatedRequestHandler
implements RequestHandler,
Describable<ApiDescription, Request> {
    private final AnnotatedMethod createMethod;
    private final AnnotatedMethod readMethod;
    private final AnnotatedMethod updateMethod;
    private final AnnotatedMethod deleteMethod;
    private final AnnotatedMethod patchMethod;
    private final AnnotatedMethod queryMethod;
    private final AnnotatedActionMethods actionMethods;
    private final Describable<ApiDescription, Request> describable;

    AnnotatedRequestHandler(Object requestHandler) {
        if (!requestHandler.getClass().isAnnotationPresent(org.forgerock.api.annotations.RequestHandler.class)) {
            throw new IllegalArgumentException("RequestHandler missing from class: " + requestHandler.getClass().getName());
        }
        this.createMethod = AnnotatedMethod.findMethod(requestHandler, Create.class, false);
        this.readMethod = AnnotatedMethod.findMethod(requestHandler, Read.class, false);
        this.updateMethod = AnnotatedMethod.findMethod(requestHandler, Update.class, false);
        this.deleteMethod = AnnotatedMethod.findMethod(requestHandler, Delete.class, false);
        this.patchMethod = AnnotatedMethod.findMethod(requestHandler, Patch.class, false);
        this.queryMethod = AnnotatedMethod.findMethod(requestHandler, Query.class, false);
        this.actionMethods = AnnotatedActionMethods.findAll(requestHandler, false);
        this.describable = requestHandler instanceof Describable ? (Describable)requestHandler : null;
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return this.readMethod.invoke(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return this.updateMethod.invoke(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return this.patchMethod.invoke(context, request);
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.queryMethod.invoke(context, (Request)request, handler);
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.actionMethods.invoke(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return this.createMethod.invoke(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return this.deleteMethod.invoke(context, request);
    }

    @Override
    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        if (this.describable == null) {
            throw new UnsupportedOperationException("The provided request handler does not support API Descriptor methods");
        }
        return this.describable.api(producer);
    }

    @Override
    public ApiDescription handleApiRequest(Context context, Request request) {
        if (this.describable == null) {
            throw new UnsupportedOperationException("The provided request handler does not support API Descriptor methods");
        }
        return this.describable.handleApiRequest(context, request);
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        if (this.describable != null) {
            this.describable.addDescriptorListener(listener);
        }
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        if (this.describable != null) {
            this.describable.removeDescriptorListener(listener);
        }
    }
}

