/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.api.annotations.Patch;
import org.forgerock.api.annotations.Read;
import org.forgerock.api.annotations.SingletonProvider;
import org.forgerock.api.annotations.Update;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedActionMethods;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.InterfaceSingletonHandler;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.Promise;

class AnnotatedSingletonHandler
extends InterfaceSingletonHandler
implements Describable<ApiDescription, Request> {
    private final AnnotatedMethod readMethod;
    private final AnnotatedMethod updateMethod;
    private final AnnotatedMethod patchMethod;
    private final AnnotatedActionMethods actionMethods;
    private final Describable<ApiDescription, Request> describable;

    public AnnotatedSingletonHandler(Object requestHandler) {
        super(null);
        if (!requestHandler.getClass().isAnnotationPresent(SingletonProvider.class)) {
            throw new IllegalArgumentException("SingletonProvider missing from class: " + requestHandler.getClass().getName());
        }
        this.readMethod = AnnotatedMethod.findMethod(requestHandler, Read.class, false);
        this.updateMethod = AnnotatedMethod.findMethod(requestHandler, Update.class, false);
        this.patchMethod = AnnotatedMethod.findMethod(requestHandler, Patch.class, false);
        this.actionMethods = AnnotatedActionMethods.findAll(requestHandler, false);
        this.describable = requestHandler instanceof Describable ? (Describable)requestHandler : null;
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return this.readMethod.invoke(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return this.updateMethod.invoke(context, request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return this.patchMethod.invoke(context, request);
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.actionMethods.invoke(context, request);
    }

    @Override
    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        if (this.describable == null) {
            throw new UnsupportedOperationException("The provided request handler does not support API Descriptor methods");
        }
        return this.describable.api(producer);
    }

    @Override
    public ApiDescription handleApiRequest(Context context, Request request) {
        if (this.describable == null) {
            throw new UnsupportedOperationException("The provided request handler does not support API Descriptor methods");
        }
        return this.describable.handleApiRequest(context, request);
    }

    @Override
    public void addDescriptorListener(Describable.Listener listener) {
        if (this.describable != null) {
            this.describable.addDescriptorListener(listener);
        }
    }

    @Override
    public void removeDescriptorListener(Describable.Listener listener) {
        if (this.describable != null) {
            this.describable.removeDescriptorListener(listener);
        }
    }
}

