/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.util.Reject;

public final class PatchOperation {
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_FROM = "from";
    public static final String FIELD_OPERATION = "operation";
    public static final String FIELD_VALUE = "value";
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_INCREMENT = "increment";
    public static final String OPERATION_REMOVE = "remove";
    public static final String OPERATION_REPLACE = "replace";
    public static final String OPERATION_MOVE = "move";
    public static final String OPERATION_COPY = "copy";
    public static final String OPERATION_TRANSFORM = "transform";
    private final JsonPointer field;
    private final JsonPointer from;
    private final String operation;
    private final JsonValue value;
    private JsonValue json;

    public static PatchOperation add(JsonPointer field2, Object value2) {
        return PatchOperation.operation(OPERATION_ADD, field2, value2);
    }

    public static PatchOperation add(String field2, Object value2) {
        return PatchOperation.add(new JsonPointer(field2), value2);
    }

    public static PatchOperation increment(JsonPointer field2, Number amount) {
        return PatchOperation.operation(OPERATION_INCREMENT, field2, (Object)amount);
    }

    public static PatchOperation increment(String field2, Number amount) {
        return PatchOperation.increment(new JsonPointer(field2), amount);
    }

    public static PatchOperation remove(JsonPointer field2) {
        return PatchOperation.remove(field2, null);
    }

    public static PatchOperation remove(JsonPointer field2, Object value2) {
        return PatchOperation.operation(OPERATION_REMOVE, field2, value2);
    }

    public static PatchOperation remove(String field2) {
        return PatchOperation.remove(new JsonPointer(field2));
    }

    public static PatchOperation remove(String field2, Object value2) {
        return PatchOperation.remove(new JsonPointer(field2), value2);
    }

    public static PatchOperation replace(JsonPointer field2, Object value2) {
        return PatchOperation.operation(OPERATION_REPLACE, field2, value2);
    }

    public static PatchOperation replace(String field2, Object value2) {
        return PatchOperation.replace(new JsonPointer(field2), value2);
    }

    public static PatchOperation move(JsonPointer from, JsonPointer field2) {
        return PatchOperation.operation(OPERATION_MOVE, from, field2);
    }

    public static PatchOperation move(String from, String field2) {
        return PatchOperation.operation(OPERATION_MOVE, new JsonPointer(from), new JsonPointer(field2));
    }

    public static PatchOperation copy(JsonPointer from, JsonPointer field2) {
        return PatchOperation.operation(OPERATION_COPY, from, field2);
    }

    public static PatchOperation copy(String from, String field2) {
        return PatchOperation.operation(OPERATION_COPY, new JsonPointer(from), new JsonPointer(field2));
    }

    public static PatchOperation transform(JsonPointer field2, Object transform) {
        return PatchOperation.operation(OPERATION_TRANSFORM, field2, transform);
    }

    public static PatchOperation transform(String field2, Object transform) {
        return PatchOperation.operation(OPERATION_TRANSFORM, new JsonPointer(field2), transform);
    }

    public static PatchOperation operation(String operation, JsonPointer field2, Object value2) {
        return new PatchOperation(operation, field2, null, JsonValue.json(value2), null);
    }

    private static PatchOperation operation(String operation, JsonPointer from, JsonPointer field2) {
        return new PatchOperation(operation, field2, from, JsonValue.json(null), null);
    }

    public static PatchOperation operation(String operation, String field2, Object value2) {
        return PatchOperation.operation(operation, new JsonPointer(field2), value2);
    }

    public static PatchOperation copyOf(PatchOperation operation) {
        return new PatchOperation(operation.getOperation(), operation.getField(), operation.getFrom(), operation.getValue().copy(), operation.toJsonValue().copy());
    }

    public static PatchOperation valueOf(JsonValue json) throws BadRequestException {
        if (!json.isMap()) {
            throw new BadRequestException("The request could not be processed because the provided content is not a valid JSON patch");
        }
        try {
            return new PatchOperation(json.get(FIELD_OPERATION).asString(), json.get(FIELD_FIELD).as(JsonValueFunctions.pointer()), json.get(FIELD_FROM).as(JsonValueFunctions.pointer()), json.get(FIELD_VALUE), json);
        }
        catch (Exception e) {
            throw new BadRequestException("The request could not be processed because the provided content is not a valid JSON patch: " + e.getMessage(), (Throwable)e);
        }
    }

    public static List<PatchOperation> valueOfList(JsonValue json) throws BadRequestException {
        if (!json.isList()) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON array of patch operations");
        }
        ArrayList<PatchOperation> patch = new ArrayList<PatchOperation>(json.size());
        for (JsonValue operation : json) {
            patch.add(PatchOperation.valueOf(operation));
        }
        return patch;
    }

    private PatchOperation(String operation, JsonPointer field2, JsonPointer from, JsonValue value2, JsonValue json) {
        Reject.checkNotNull(operation, "Cannot instantiate PatchOperation with null 'operation' value");
        Reject.checkNotNull(field2, "Cannot instantiate PatchOperation with null 'field' value");
        Reject.checkNotNull(value2, "Cannot instantiate PatchOperation with null 'value' value");
        this.operation = operation;
        this.checkOperationType();
        this.field = field2;
        this.value = value2;
        this.from = from;
        this.json = json;
        if (this.isAdd() || this.isIncrement() || this.isReplace() || this.isTransform()) {
            if (value2.isNull()) {
                throw new NullPointerException("No value field provided for '" + operation + "' operation");
            }
            if (from != null) {
                throw new IllegalArgumentException("'" + operation + "' does not accept from field");
            }
            if (this.isIncrement() && !value2.isNumber()) {
                throw new IllegalArgumentException("Non-numeric value provided for increment operation");
            }
        } else if (this.isRemove()) {
            if (from != null) {
                throw new IllegalArgumentException("'" + operation + "' does not accept from field");
            }
        } else if (this.isCopy() || this.isMove()) {
            if (from == null || from.isEmpty()) {
                throw new NullPointerException("No from field provided for '" + operation + "' operation");
            }
            if (value2.isNotNull()) {
                throw new IllegalArgumentException("'" + operation + "' does not accept value field");
            }
        }
    }

    private void checkOperationType() {
        if (!(this.isAdd() || this.isRemove() || this.isIncrement() || this.isReplace() || this.isTransform() || this.isMove() || this.isCopy())) {
            throw new IllegalArgumentException("Invalid patch operation type " + this.operation);
        }
    }

    public JsonPointer getField() {
        return this.field;
    }

    public JsonPointer getFrom() {
        return this.from;
    }

    public String getOperation() {
        return this.operation;
    }

    public JsonValue getValue() {
        return this.value;
    }

    public boolean isAdd() {
        return this.is(OPERATION_ADD);
    }

    public boolean isIncrement() {
        return this.is(OPERATION_INCREMENT);
    }

    public boolean isRemove() {
        return this.is(OPERATION_REMOVE);
    }

    public boolean isReplace() {
        return this.is(OPERATION_REPLACE);
    }

    public boolean isMove() {
        return this.is(OPERATION_MOVE);
    }

    public boolean isCopy() {
        return this.is(OPERATION_COPY);
    }

    public boolean isTransform() {
        return this.is(OPERATION_TRANSFORM);
    }

    public JsonValue toJsonValue() {
        if (this.json == null) {
            this.json = new JsonValue(new LinkedHashMap());
            this.json.put(FIELD_OPERATION, (Object)this.operation);
            this.json.put(FIELD_FIELD, (Object)this.field.toString());
            if (this.from != null) {
                this.json.put(FIELD_FROM, (Object)this.from.toString());
            }
            if (this.value.isNotNull()) {
                this.json.put(FIELD_VALUE, this.value.getObject());
            }
        }
        return this.json;
    }

    public String toString() {
        return this.toJsonValue().toString();
    }

    private boolean is(String type2) {
        return this.operation.equalsIgnoreCase(type2);
    }
}

