/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.http.routing.ApiVersionRouterContext;
import org.forgerock.http.routing.ResourceApiVersionBehaviourManager;
import org.forgerock.http.routing.Version;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AdviceContext;
import org.forgerock.json.resource.AdviceWarning;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public class ResourceApiVersionRoutingFilter
extends org.forgerock.http.routing.ResourceApiVersionRoutingFilter
implements Filter {
    ResourceApiVersionRoutingFilter(ResourceApiVersionBehaviourManager behaviourManager) {
        super(behaviourManager);
    }

    @Override
    public Promise<ActionResponse, ResourceException> filterAction(Context context, ActionRequest request, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handleAction(apiVersionRouterContext, request));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> filterCreate(Context context, CreateRequest request, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handleCreate(apiVersionRouterContext, request));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> filterDelete(Context context, DeleteRequest request, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handleDelete(apiVersionRouterContext, request));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> filterPatch(Context context, PatchRequest request, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handlePatch(apiVersionRouterContext, request));
    }

    @Override
    public Promise<QueryResponse, ResourceException> filterQuery(Context context, QueryRequest request, QueryResourceHandler handler, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handleQuery(apiVersionRouterContext, request, handler));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> filterRead(Context context, ReadRequest request, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handleRead(apiVersionRouterContext, request));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> filterUpdate(Context context, UpdateRequest request, RequestHandler next2) {
        ApiVersionRouterContext apiVersionRouterContext = this.createApiVersionRouterContext(context);
        return this.wrapWithApiVersionInfo(apiVersionRouterContext, request, next2.handleUpdate(apiVersionRouterContext, request));
    }

    private <V extends Response> Promise<V, ResourceException> wrapWithApiVersionInfo(final ApiVersionRouterContext apiVersionRouterContext, final Request request, Promise<V, ResourceException> promise) {
        return promise.thenOnResult(new ResultHandler<V>(){

            @Override
            public void handleResult(V response) {
                ResourceApiVersionRoutingFilter.setApiVersionInfo(apiVersionRouterContext, request, response);
            }
        }).thenOnException(new ExceptionHandler<ResourceException>(){

            @Override
            public void handleException(ResourceException e) {
                ResourceApiVersionRoutingFilter.setApiVersionInfo(apiVersionRouterContext, request, e);
            }
        });
    }

    static void setApiVersionInfo(ApiVersionRouterContext apiVersionRouterContext, Request request, Response response) {
        AdviceContext adviceContext;
        Version resourceVersion = apiVersionRouterContext.getResourceVersion();
        if (resourceVersion != null) {
            response.setResourceApiVersion(resourceVersion);
        }
        if (apiVersionRouterContext.isWarningEnabled() && request.getResourceVersion() == null && !(adviceContext = apiVersionRouterContext.asContext(AdviceContext.class)).getAdvices().containsKey("crest")) {
            adviceContext.putAdvice("Warning", AdviceWarning.getNotPresent("CREST", "Accept-API-Version").toString());
        }
    }
}

