/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import com.google.common.html.HtmlEscapers;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.ForbiddenException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PermanentException;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.PreconditionRequiredException;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.RetryableException;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.json.resource.UncategorizedException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class ResourceException
extends IOException
implements Response {
    public static final String FIELD_DETAIL = "detail";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_REASON = "reason";
    public static final String FIELD_CODE = "code";
    public static final String FIELD_CAUSE = "cause";
    public static final int BAD_REQUEST = 400;
    public static final int CONFLICT = 409;
    public static final int FORBIDDEN = 403;
    public static final int INTERNAL_ERROR = 500;
    public static final int NOT_FOUND = 404;
    public static final int NOT_SUPPORTED = 501;
    public static final int UNAVAILABLE = 503;
    public static final int VERSION_MISMATCH = 412;
    public static final int VERSION_REQUIRED = 428;
    private static final long serialVersionUID = 1L;
    private boolean includeCause = false;
    private final int code;
    private String reason;
    private JsonValue detail = new JsonValue(null);
    private Version resourceApiVersion;

    public static ResourceException newResourceException(int code) {
        return ResourceException.newResourceException(code, null);
    }

    public static ResourceException newResourceException(int code, String message2) {
        return ResourceException.newResourceException(code, message2, null);
    }

    public static ResourceException newResourceException(int code, String message2, Throwable cause2) {
        ResourceException ex;
        switch (code) {
            case 400: {
                ex = new BadRequestException(message2, cause2);
                break;
            }
            case 403: {
                ex = new ForbiddenException(message2, cause2);
                break;
            }
            case 404: {
                ex = new NotFoundException(message2, cause2);
                break;
            }
            case 409: {
                ex = new ConflictException(message2, cause2);
                break;
            }
            case 412: {
                ex = new PreconditionFailedException(message2, cause2);
                break;
            }
            case 428: {
                ex = new PreconditionRequiredException(message2, cause2);
                break;
            }
            case 500: {
                ex = new InternalServerErrorException(message2, cause2);
                break;
            }
            case 501: {
                ex = new NotSupportedException(message2, cause2);
                break;
            }
            case 503: {
                ex = new ServiceUnavailableException(message2, cause2);
                break;
            }
            case 408: 
            case 504: {
                ex = new RetryableException(code, message2, cause2);
                break;
            }
            case 401: 
            case 402: 
            case 405: 
            case 406: 
            case 407: 
            case 410: 
            case 411: 
            case 413: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 502: 
            case 505: {
                ex = new PermanentException(code, message2, cause2);
                break;
            }
            default: {
                ex = new UncategorizedException(code, message2, cause2);
            }
        }
        return ex;
    }

    @Deprecated
    public static ResourceException getException(int code) {
        return ResourceException.newResourceException(code, null);
    }

    @Deprecated
    public static ResourceException getException(int code, String message2) {
        return ResourceException.newResourceException(code, message2, null);
    }

    @Deprecated
    public static ResourceException getException(int code, String message2, Throwable cause2) {
        return ResourceException.newResourceException(code, message2, cause2);
    }

    private static String reason(int code) {
        String result2 = "Resource Exception";
        switch (code) {
            case 400: {
                result2 = "Bad Request";
                break;
            }
            case 401: {
                result2 = "Unauthorized";
                break;
            }
            case 402: {
                result2 = "Payment Required";
                break;
            }
            case 403: {
                result2 = "Forbidden";
                break;
            }
            case 404: {
                result2 = "Not Found";
                break;
            }
            case 405: {
                result2 = "Method Not Allowed";
                break;
            }
            case 406: {
                result2 = "Not Acceptable";
                break;
            }
            case 407: {
                result2 = "Proxy Authentication Required";
                break;
            }
            case 408: {
                result2 = "Request Time-out";
                break;
            }
            case 409: {
                result2 = "Conflict";
                break;
            }
            case 410: {
                result2 = "Gone";
                break;
            }
            case 411: {
                result2 = "Length Required";
                break;
            }
            case 412: {
                result2 = "Precondition Failed";
                break;
            }
            case 413: {
                result2 = "Request Entity Too Large";
                break;
            }
            case 414: {
                result2 = "Request-URI Too Large";
                break;
            }
            case 415: {
                result2 = "Unsupported Media Type";
                break;
            }
            case 416: {
                result2 = "Requested range not satisfiable";
                break;
            }
            case 417: {
                result2 = "Expectation Failed";
                break;
            }
            case 428: {
                result2 = "Precondition Required";
                break;
            }
            case 500: {
                result2 = "Internal Server Error";
                break;
            }
            case 501: {
                result2 = "Not Implemented";
                break;
            }
            case 502: {
                result2 = "Bad Gateway";
                break;
            }
            case 503: {
                result2 = "Service Unavailable";
                break;
            }
            case 504: {
                result2 = "Gateway Time-out";
                break;
            }
            case 505: {
                result2 = "HTTP Version not supported";
            }
        }
        return result2;
    }

    private static String message(int code, String message2, Throwable cause2) {
        if (message2 != null) {
            return message2;
        }
        if (cause2 != null && cause2.getMessage() != null) {
            return cause2.getMessage();
        }
        return ResourceException.reason(code);
    }

    protected ResourceException(int code) {
        this(code, null, null);
    }

    protected ResourceException(int code, String message2) {
        this(code, message2, null);
    }

    protected ResourceException(int code, Throwable cause2) {
        this(code, null, cause2);
    }

    protected ResourceException(int code, String message2, Throwable cause2) {
        super(ResourceException.message(code, message2, cause2), cause2);
        this.code = code;
        this.reason = ResourceException.reason(code);
    }

    public final int getCode() {
        return this.code;
    }

    public boolean isServerError() {
        return this.code >= 500 && this.code <= 599;
    }

    public final JsonValue getDetail() {
        return this.detail;
    }

    public final String getReason() {
        return this.reason;
    }

    public final ResourceException setDetail(JsonValue detail) {
        this.detail = detail != null ? detail : new JsonValue(null);
        return this;
    }

    public final ResourceException setReason(String reason2) {
        this.reason = reason2;
        return this;
    }

    public final ResourceException includeCauseInJsonValue() {
        this.includeCause = true;
        return this;
    }

    public final JsonValue toJsonValue() {
        String message2;
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>(4);
        result2.put(FIELD_CODE, this.code);
        if (this.reason != null) {
            result2.put(FIELD_REASON, this.reason);
        }
        if ((message2 = this.getMessage()) != null) {
            result2.put(FIELD_MESSAGE, HtmlEscapers.htmlEscaper().escape(message2));
        }
        if (!this.detail.isNull()) {
            result2.put(FIELD_DETAIL, this.detail.getObject());
        }
        if (this.includeCause && this.getCause() != null && this.getCause().getMessage() != null) {
            LinkedHashMap<String, String> cause2 = new LinkedHashMap<String, String>(2);
            cause2.put(FIELD_MESSAGE, this.getCause().getMessage());
            result2.put(FIELD_CAUSE, cause2);
        }
        return new JsonValue(result2);
    }

    @Override
    public void setResourceApiVersion(Version version) {
        this.resourceApiVersion = version;
    }

    @Override
    public Version getResourceApiVersion() {
        return this.resourceApiVersion;
    }

    public <V> Promise<V, ResourceException> asPromise() {
        return Promises.newExceptionPromise(this);
    }
}

