/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Response;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class Responses {
    private Responses() {
    }

    public static ActionResponse newActionResponse(JsonValue json) {
        return new ActionResponseImpl(json);
    }

    public static ResourceResponse newResourceResponse(String id2, String revision, JsonValue content) {
        return new ResourceResponseImpl(id2, revision, content);
    }

    public static QueryResponse newQueryResponse() {
        return Responses.newQueryResponse(null);
    }

    public static QueryResponse newQueryResponse(String pagedResultsCookie) {
        return Responses.newQueryResponse(pagedResultsCookie, CountPolicy.NONE, -1);
    }

    public static QueryResponse newQueryResponse(String pagedResultsCookie, CountPolicy totalPagedResultsPolicy, int totalPagedResults) {
        return new QueryResponseImpl(pagedResultsCookie, totalPagedResultsPolicy, totalPagedResults, -1);
    }

    @Deprecated
    public static QueryResponse newRemainingResultsResponse(String pagedResultsCookie, int remainingPagedResults) {
        return new QueryResponseImpl(pagedResultsCookie, CountPolicy.NONE, -1, remainingPagedResults);
    }

    private static final class QueryResponseImpl
    extends AbstractResponseImpl
    implements QueryResponse {
        private final String pagedResultsCookie;
        private final CountPolicy totalPagedResultsPolicy;
        private final int totalPagedResults;
        private final int remainingPagedResults;

        private QueryResponseImpl(String pagedResultsCookie, CountPolicy totalPagedResultsPolicy, int totalPagedResults, int remainingPagedResults) {
            this.pagedResultsCookie = pagedResultsCookie;
            if (totalPagedResultsPolicy == null) {
                totalPagedResultsPolicy = CountPolicy.NONE;
            }
            this.totalPagedResultsPolicy = totalPagedResultsPolicy;
            this.totalPagedResults = totalPagedResults;
            this.remainingPagedResults = remainingPagedResults;
        }

        @Override
        public CountPolicy getTotalPagedResultsPolicy() {
            return this.totalPagedResultsPolicy;
        }

        @Override
        public String getPagedResultsCookie() {
            return this.pagedResultsCookie;
        }

        @Override
        public int getTotalPagedResults() {
            return this.totalPagedResults;
        }

        @Override
        public int getRemainingPagedResults() {
            return this.remainingPagedResults;
        }

        @Override
        public Promise<QueryResponse, ResourceException> asPromise() {
            return Promises.newResultPromise(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryResponseImpl that = (QueryResponseImpl)o;
            return this.totalPagedResults == that.totalPagedResults && Objects.equals(this.pagedResultsCookie, this.pagedResultsCookie) && this.totalPagedResultsPolicy == that.totalPagedResultsPolicy && this.remainingPagedResults == that.remainingPagedResults;
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.pagedResultsCookie);
            result2 = 31 * result2 + this.totalPagedResultsPolicy.hashCode();
            result2 = 31 * result2 + this.totalPagedResults;
            result2 = 31 * result2 + this.remainingPagedResults;
            return result2;
        }

        public String toString() {
            JsonValue wrapper = new JsonValue(new LinkedHashMap(4));
            wrapper.add("totalPagedResults", (Object)this.totalPagedResults);
            wrapper.add("totalPagedResultsPolicy", (Object)this.totalPagedResultsPolicy);
            wrapper.add("remainingPagedResults", (Object)this.remainingPagedResults);
            wrapper.add("pagedResultsCookie", (Object)this.pagedResultsCookie);
            return wrapper.toString();
        }
    }

    private static final class ResourceResponseImpl
    extends AbstractResponseImpl
    implements ResourceResponse {
        private final JsonValue content;
        private final String id;
        private final String revision;
        private final List<JsonPointer> fields;

        private ResourceResponseImpl(String id2, String revision, JsonValue content) {
            this.id = id2;
            this.revision = revision;
            this.content = content;
            this.fields = new ArrayList<JsonPointer>();
        }

        @Override
        public JsonValue getContent() {
            return this.content;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public List<JsonPointer> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        @Override
        public boolean hasFields() {
            return !this.fields.isEmpty();
        }

        @Override
        public void addField(JsonPointer ... fields2) {
            for (JsonPointer field2 : fields2) {
                this.fields.add(field2);
            }
        }

        @Override
        public Promise<ResourceResponse, ResourceException> asPromise() {
            return Promises.newResultPromise(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ResourceResponseImpl) {
                ResourceResponseImpl that = (ResourceResponseImpl)obj;
                return this.isEqual(this.id, that.id) && this.isEqual(this.revision, that.revision);
            }
            return false;
        }

        private boolean isEqual(String s1, String s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }

        @Override
        public int hashCode() {
            int hash2 = this.id != null ? this.id.hashCode() : 17;
            return hash2 * 31 + (this.revision != null ? this.revision.hashCode() : 0);
        }

        public String toString() {
            JsonValue wrapper = new JsonValue(new LinkedHashMap(3));
            wrapper.add("id", (Object)this.id);
            wrapper.add("rev", (Object)this.revision);
            wrapper.add("content", (Object)this.content);
            return wrapper.toString();
        }
    }

    private static final class ActionResponseImpl
    extends AbstractResponseImpl
    implements ActionResponse {
        private final JsonValue content;

        private ActionResponseImpl(JsonValue content) {
            this.content = content;
        }

        @Override
        public JsonValue getJsonContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionResponse that = (ActionResponse)o;
            return this.getJsonContent().getObject().equals(that.getJsonContent().getObject());
        }

        public int hashCode() {
            return this.getJsonContent().getObject().hashCode();
        }

        @Override
        public Promise<ActionResponse, ResourceException> asPromise() {
            return Promises.newResultPromise(this);
        }

        public String toString() {
            return JsonValue.json(JsonValue.object(JsonValue.field("content", this.content.getObject()))).toString();
        }
    }

    private static abstract class AbstractResponseImpl
    implements Response {
        private Version resourceApiVersion;

        private AbstractResponseImpl() {
        }

        @Override
        public void setResourceApiVersion(Version version) {
            this.resourceApiVersion = version;
        }

        @Override
        public Version getResourceApiVersion() {
            return this.resourceApiVersion;
        }
    }
}

