/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.List;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.ResourceApiVersionBehaviourManager;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.Version;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceApiVersionRoutingFilter;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;

public final class RouteMatchers {
    private RouteMatchers() {
    }

    public static RouteMatcher<Request> requestUriMatcher(RoutingMode mode2, String template) {
        return new RequestUriRouteMatcher(org.forgerock.http.routing.RouteMatchers.uriMatcher(mode2, template));
    }

    public static ResourceApiVersionBehaviourManager newResourceApiVersionBehaviourManager() {
        return org.forgerock.http.routing.RouteMatchers.newResourceApiVersionBehaviourManager();
    }

    public static Filter resourceApiVersionContextFilter(ResourceApiVersionBehaviourManager behaviourManager) {
        return new ResourceApiVersionRoutingFilter(behaviourManager);
    }

    public static RouteMatcher<Request> requestResourceApiVersionMatcher(Version version) {
        return new RequestApiVersionRouteMatcher(org.forgerock.http.routing.RouteMatchers.resourceApiVersionMatcher(version));
    }

    private static final class RequestApiVersionRouteMatcher
    extends RouteMatcher<Request> {
        private final RouteMatcher<Version> delegate;

        private RequestApiVersionRouteMatcher(RouteMatcher<Version> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RouteMatch evaluate(Context context, Request request) {
            return this.delegate.evaluate(context, request.getResourceVersion());
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String idFragment() {
            return this.delegate.idFragment();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestApiVersionRouteMatcher)) {
                return false;
            }
            RequestApiVersionRouteMatcher that = (RequestApiVersionRouteMatcher)o;
            return this.delegate.equals(that.delegate);
        }

        @Override
        public <T> T transformApi(T t, ApiProducer<T> apiProducer) {
            return this.delegate.transformApi(t, apiProducer);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    private static final class RequestUriRouteMatcher
    extends RouteMatcher<Request> {
        private final RouteMatcher<List<String>> delegate;

        private RequestUriRouteMatcher(RouteMatcher<List<String>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RouteMatch evaluate(Context context, Request request) {
            ArrayList<String> pathElements = new ArrayList<String>(request.getResourcePathObject().size());
            for (String pathElement : request.getResourcePathObject()) {
                pathElements.add(pathElement);
            }
            return this.delegate.evaluate(context, pathElements);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String idFragment() {
            return this.delegate.idFragment();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestUriRouteMatcher)) {
                return false;
            }
            RequestUriRouteMatcher that = (RequestUriRouteMatcher)o;
            return this.delegate.equals(that.delegate);
        }

        @Override
        public <T> T transformApi(T t, ApiProducer<T> apiProducer) {
            return this.delegate.transformApi(t, apiProducer);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

