/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.routing.ApiVersionRouterContext;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceApiVersionRoutingFilter;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.services.routing.AbstractRouter;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatcher;
import org.forgerock.util.Pair;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class Router
extends AbstractRouter<Router, Request, RequestHandler, ApiDescription>
implements RequestHandler {
    public Router() {
    }

    public Router(AbstractRouter<Router, Request, RequestHandler, ApiDescription> router) {
        super(router);
    }

    @Override
    protected Router getThis() {
        return this;
    }

    @Override
    protected RouteMatcher<Request> uriMatcher(RoutingMode mode2, String pattern) {
        return RouteMatchers.requestUriMatcher(mode2, pattern);
    }

    public RouteMatcher<Request> addRoute(UriTemplate uriTemplate, CollectionResourceProvider provider) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, uriTemplate.template);
        this.addRoute(routeMatcher, Resources.newHandler(provider));
        return routeMatcher;
    }

    public RouteMatcher<Request> addRoute(UriTemplate uriTemplate, SingletonResourceProvider provider) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, uriTemplate.template);
        this.addRoute(routeMatcher, Resources.newHandler(provider));
        return routeMatcher;
    }

    public RouteMatcher<Request> addRoute(RoutingMode mode2, UriTemplate uriTemplate, RequestHandler handler) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestUriMatcher(mode2, uriTemplate.template);
        this.addRoute(routeMatcher, handler);
        return routeMatcher;
    }

    public static UriTemplate uriTemplate(String template) {
        return new UriTemplate(template);
    }

    public RouteMatcher<Request> addRoute(Version version, CollectionResourceProvider provider) {
        return this.addRoute(version, Resources.newHandler(provider));
    }

    public RouteMatcher<Request> addRoute(Version version, SingletonResourceProvider provider) {
        return this.addRoute(version, Resources.newHandler(provider));
    }

    public RouteMatcher<Request> addRoute(Version version, RequestHandler handler) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestResourceApiVersionMatcher(version);
        this.addRoute(routeMatcher, handler);
        return routeMatcher;
    }

    private Pair<Context, RequestHandler> getBestMatch(Context context, Request request) throws ResourceException {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestRoute(context, request);
            if (bestMatch == null) {
                throw new NotFoundException(String.format("Resource '%s' not found", request.getResourcePath()));
            }
            return bestMatch;
        }
        catch (IncomparableRouteMatchException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext(bestMatch.getFirst());
            ActionRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfActionRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return bestMatch.getSecond().handleAction(bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext(bestMatch.getFirst());
            CreateRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfCreateRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return bestMatch.getSecond().handleCreate(bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext(bestMatch.getFirst());
            DeleteRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfDeleteRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return bestMatch.getSecond().handleDelete(bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext(bestMatch.getFirst());
            PatchRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfPatchRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return bestMatch.getSecond().handlePatch(bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, final QueryRequest request, final QueryResourceHandler handler) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            final Context decoratedContext = bestMatch.getFirst();
            UriRouterContext routerContext = this.getRouterContext(decoratedContext);
            QueryRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfQueryRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            QueryResourceHandler resourceHandler = new QueryResourceHandler(){

                @Override
                public boolean handleResource(ResourceResponse resource2) {
                    if (decoratedContext.containsContext(ApiVersionRouterContext.class)) {
                        ApiVersionRouterContext apiVersionRouterContext = decoratedContext.asContext(ApiVersionRouterContext.class);
                        ResourceApiVersionRoutingFilter.setApiVersionInfo(apiVersionRouterContext, request, resource2);
                    }
                    return handler.handleResource(resource2);
                }
            };
            return bestMatch.getSecond().handleQuery(decoratedContext, routedRequest, resourceHandler);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext(bestMatch.getFirst());
            ReadRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfReadRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return bestMatch.getSecond().handleRead(bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext(bestMatch.getFirst());
            UpdateRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfUpdateRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return bestMatch.getSecond().handleUpdate(bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public ApiDescription handleApiRequest(Context context, Request request) {
        try {
            RequestHandler handler;
            Pair bestRoute = this.getBestRoute(context, request);
            if (bestRoute != null && (handler = (RequestHandler)bestRoute.getSecond()) instanceof Describable) {
                Context nextContext = bestRoute.getFirst();
                UriRouterContext routerContext = this.getRouterContext(nextContext);
                Request routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfApiRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
                return (ApiDescription)((Describable)((Object)handler)).handleApiRequest(nextContext, routedRequest);
            }
        }
        catch (IncomparableRouteMatchException e) {
            throw new IllegalStateException(e);
        }
        if (this.thisRouterUriMatcher.evaluate(context, request) != null) {
            return (ApiDescription)this.api;
        }
        throw new UnsupportedOperationException("No route matched the request resource path " + request.getResourcePath());
    }

    private UriRouterContext getRouterContext(Context context) {
        return context.containsContext(UriRouterContext.class) ? context.asContext(UriRouterContext.class) : null;
    }

    private boolean wasRouted(Context originalContext, UriRouterContext routerContext) {
        return routerContext != null && (!originalContext.containsContext(UriRouterContext.class) || routerContext != originalContext.asContext(UriRouterContext.class));
    }

    private String getResourcePath(UriRouterContext routerContext) {
        return routerContext.getRemainingUri();
    }

    public static final class UriTemplate {
        private final String template;

        private UriTemplate(String template) {
            this.template = template;
        }

        public String toString() {
            return this.template;
        }
    }
}

