/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPointer;

public final class SortKey {
    private final JsonPointer field;
    private final boolean isAscendingOrder;

    public static SortKey ascendingOrder(JsonPointer field2) {
        return new SortKey(field2, true);
    }

    public static SortKey ascendingOrder(String field2) {
        try {
            return SortKey.ascendingOrder(new JsonPointer(field2));
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static SortKey descendingOrder(JsonPointer field2) {
        return new SortKey(field2, false);
    }

    public static SortKey descendingOrder(String field2) {
        try {
            return SortKey.descendingOrder(new JsonPointer(field2));
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static SortKey reverseOrder(SortKey key2) {
        return new SortKey(key2.field, !key2.isAscendingOrder);
    }

    private SortKey(JsonPointer field2, boolean isAscendingOrder) {
        this.field = field2;
        this.isAscendingOrder = isAscendingOrder;
    }

    public JsonPointer getField() {
        return this.field;
    }

    public boolean isAscendingOrder() {
        return this.isAscendingOrder;
    }

    public static SortKey valueOf(String s2) {
        if (s2.length() == 0) {
            throw new IllegalArgumentException("Empty sort key");
        }
        switch (s2.charAt(0)) {
            case '-': {
                return SortKey.descendingOrder(s2.substring(1));
            }
            case '+': {
                return SortKey.ascendingOrder(s2.substring(1));
            }
        }
        return SortKey.ascendingOrder(s2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isAscendingOrder ? (char)'+' : '-');
        builder.append(this.field);
        return builder.toString();
    }
}

