/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.LinkedList;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.SynchronousRequestHandler;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

class SynchronousRequestHandlerAdapter
implements RequestHandler {
    private final SynchronousRequestHandler syncHandler;

    SynchronousRequestHandlerAdapter(SynchronousRequestHandler syncHandler) {
        this.syncHandler = syncHandler;
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        try {
            return Promises.newResultPromise(this.syncHandler.handleUpdate(context, request));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        try {
            return Promises.newResultPromise(this.syncHandler.handleRead(context, request));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        try {
            LinkedList<ResourceResponse> resources = new LinkedList<ResourceResponse>();
            QueryResponse result2 = this.syncHandler.handleQuery(context, request, resources);
            for (ResourceResponse resource2 : resources) {
                handler.handleResource(resource2);
            }
            return Promises.newResultPromise(result2);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        try {
            return Promises.newResultPromise(this.syncHandler.handlePatch(context, request));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        try {
            return Promises.newResultPromise(this.syncHandler.handleDelete(context, request));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        try {
            return Promises.newResultPromise(this.syncHandler.handleCreate(context, request));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        try {
            return Promises.newResultPromise(this.syncHandler.handleAction(context, request));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise(e);
        }
    }
}

