/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor.examples.provider.version1;

import org.forgerock.api.annotations.Action;
import org.forgerock.api.annotations.ApiError;
import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.annotations.Create;
import org.forgerock.api.annotations.Delete;
import org.forgerock.api.annotations.Handler;
import org.forgerock.api.annotations.Operation;
import org.forgerock.api.annotations.Parameter;
import org.forgerock.api.annotations.Patch;
import org.forgerock.api.annotations.Path;
import org.forgerock.api.annotations.Query;
import org.forgerock.api.annotations.Read;
import org.forgerock.api.annotations.Schema;
import org.forgerock.api.annotations.Update;
import org.forgerock.api.enums.CountPolicy;
import org.forgerock.api.enums.PagingMode;
import org.forgerock.api.enums.QueryType;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.MemoryBackend;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UncategorizedException;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.descriptor.examples.model.User;
import org.forgerock.json.resource.descriptor.examples.provider.version1.DeviceCollectionProviderV1;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

@CollectionProvider(details=@Handler(id="users:1.0", title="Users", description="This example version 1.0 user service represents a Users resource with CQ operations on the users collection and CRUDPA operations available for the user item. Action is to reset the password. Items can have devices version 1.0 subresources. This service is populated by the /users endpoint and the /admins endpoint", resourceSchema=@Schema(fromType=User.class), mvccSupported=true), pathParam=@Parameter(name="userId", type="string", description="The user ID from the path"))
public class UserCollectionProviderV1 {
    private final DeviceCollectionProviderV1 deviceCollectionProvider;
    protected MemoryBackend memoryBackend;

    public UserCollectionProviderV1(MemoryBackend memoryBackend, DeviceCollectionProviderV1 deviceCollectionProvider) {
        this.memoryBackend = memoryBackend;
        this.deviceCollectionProvider = deviceCollectionProvider;
    }

    @Query(operationDescription=@Operation(description="i18n:api-dictionary-example#user_query_operation_description", locales={"en-GB", "en-US"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication")}), type=QueryType.FILTER, countPolicies={CountPolicy.NONE}, pagingModes={PagingMode.COOKIE, PagingMode.OFFSET}, queryableFields={"uid", "name", "password"})
    public Promise<QueryResponse, ResourceException> query(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.memoryBackend.queryCollection(context, request, handler);
    }

    @Create(operationDescription=@Operation(description="i18n:api-dictionary-example#user_create_operation_description", locales={"en-GB", "en-US", "fr"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication")}))
    public Promise<ResourceResponse, ResourceException> create(Context context, CreateRequest request) {
        return this.memoryBackend.createInstance(context, request);
    }

    @Read(operationDescription=@Operation(description="User read operation", locales={"en-GB", "en-US"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication"), @ApiError(code=404, description="User not found")}))
    public Promise<ResourceResponse, ResourceException> read(Context context, String id2, ReadRequest request) {
        return this.memoryBackend.readInstance(context, id2, request);
    }

    @Update(operationDescription=@Operation(description="User update opreation", locales={"en-GB", "en-US"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication")}))
    public Promise<ResourceResponse, ResourceException> update(Context context, String id2, UpdateRequest request) {
        return this.memoryBackend.updateInstance(context, id2, request);
    }

    @Delete(operationDescription=@Operation(description="User delete opreation", locales={"en-GB", "en-US"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication")}))
    public Promise<ResourceResponse, ResourceException> delete(Context context, String id2, DeleteRequest request) {
        return this.memoryBackend.deleteInstance(context, id2, request);
    }

    @Patch(operationDescription=@Operation(description="User patch operation", locales={"en-GB", "en-US"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication")}))
    public Promise<ResourceResponse, ResourceException> patch(Context context, String id2, PatchRequest request) {
        return this.memoryBackend.patchInstance(context, id2, request);
    }

    @Action(operationDescription=@Operation(description="Reset user password", locales={"en-GB", "en-US"}, errors={@ApiError(id="badRequest", code=400, description="Indicates that the request could not be understood by the resource due to malformed syntax."), @ApiError(id="unauthorized", code=401, description="Unauthorized - Missing or bad authentication"), @ApiError(code=501, description="Action `resetPassword` reached. As it is an example service it has not been implemented.")}), name="resetPassword")
    public Promise<ActionResponse, ResourceException> resetPasswd(Context context, String id2, ActionRequest request) {
        UncategorizedException e = new UncategorizedException(501, "Action `resetPassword` reached. As it is an example service it has not been implemented.", null);
        return Promises.newExceptionPromise(e);
    }

    @Path(value="/devices")
    public DeviceCollectionProviderV1 devices() {
        return this.deviceCollectionProvider;
    }
}

