/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.examples;

import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.Version;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.MemoryBackend;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.examples.DemoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class VersionedResourcesDemo {
    private VersionedResourcesDemo() {
    }

    public static void main(String ... args2) throws ResourceException {
        try (ConnectionFactory server = VersionedResourcesDemo.getConnectionFactory();
             Connection connection = server.getConnection();){
            DemoUtils.log((String)"Reading version 1.0 of resource");
            ResourceResponse response = connection.read(DemoUtils.ctx(), Requests.newReadRequest("users/1").setResourceVersion(Version.version(1)));
            DemoUtils.log((String)("Retrieved resource with revision: " + response.getRevision()));
            DemoUtils.log((String)"Reading version 1.5 of resource");
            response = connection.read(DemoUtils.ctx(), Requests.newReadRequest("users/1").setResourceVersion(Version.version(1, 5)));
            DemoUtils.log((String)("Retrieved resource with revision: " + response.getRevision()));
            DemoUtils.log((String)"Reading version 2.0 of resource");
            response = connection.read(DemoUtils.ctx(), Requests.newReadRequest("users/1").setResourceVersion(Version.version(2)));
            DemoUtils.log((String)("Retrieved resource with revision: " + response.getRevision()));
        }
    }

    private static ConnectionFactory getConnectionFactory() throws ResourceException {
        MemoryBackend usersV1Dot0 = new MemoryBackend();
        MemoryBackend usersV1Dot5 = new MemoryBackend();
        MemoryBackend usersV2Dot0 = new MemoryBackend();
        RequestHandler rolesV1Dot0 = VersionedResourcesDemo.handler((MemoryBackend)new MemoryBackend());
        RequestHandler rolesV1Dot5 = VersionedResourcesDemo.handler((MemoryBackend)new MemoryBackend());
        RequestHandler rolesV2Dot0 = VersionedResourcesDemo.handler((MemoryBackend)new MemoryBackend());
        SingletonResourceProvider configV1Dot0 = VersionedResourcesDemo.singleton((MemoryBackend)new MemoryBackend());
        SingletonResourceProvider configV1Dot5 = VersionedResourcesDemo.singleton((MemoryBackend)new MemoryBackend());
        SingletonResourceProvider configV2Dot0 = VersionedResourcesDemo.singleton((MemoryBackend)new MemoryBackend());
        MemoryBackend groups2 = new MemoryBackend();
        Router router = new Router();
        Router usersRouter = new Router();
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/users"), usersRouter);
        usersRouter.addRoute(Version.version(1), (CollectionResourceProvider)usersV1Dot0);
        usersRouter.addRoute(Version.version(1, 5), (CollectionResourceProvider)usersV1Dot5);
        usersRouter.addRoute(Version.version(2), (CollectionResourceProvider)usersV2Dot0);
        Router rolesRouter = new Router();
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "/roles"), rolesRouter);
        rolesRouter.addRoute(RouteMatchers.requestResourceApiVersionMatcher(Version.version(1)), rolesV1Dot0);
        rolesRouter.addRoute(RouteMatchers.requestResourceApiVersionMatcher(Version.version(1, 5)), rolesV1Dot5);
        rolesRouter.addRoute(RouteMatchers.requestResourceApiVersionMatcher(Version.version(2)), rolesV2Dot0);
        Router configRouter = new Router();
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/config"), configRouter);
        configRouter.addRoute(Version.version(1), configV1Dot0);
        configRouter.addRoute(Version.version(1, 5), configV1Dot5);
        configRouter.addRoute(Version.version(2), configV2Dot0);
        router.addRoute(Router.uriTemplate("groups"), (CollectionResourceProvider)groups2);
        Connection connection = Resources.newInternalConnection(router);
        connection.create(DemoUtils.ctx(), Requests.newCreateRequest("users", "1", DemoUtils.userAliceWithIdAndRev((int)1, (int)0)).setResourceVersion(Version.version(1)));
        connection.create(DemoUtils.ctx(), Requests.newCreateRequest("users", "1", DemoUtils.userAliceWithIdAndRev((int)1, (int)1)).setResourceVersion(Version.version(1, 5)));
        connection.create(DemoUtils.ctx(), Requests.newCreateRequest("users", "1", DemoUtils.userAliceWithIdAndRev((int)1, (int)2)).setResourceVersion(Version.version(2)));
        return Resources.newInternalConnectionFactory(router);
    }

    private static SingletonResourceProvider singleton(MemoryBackend backend) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static RequestHandler handler(MemoryBackend backend) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

