/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.http.Handler;
import org.forgerock.http.MutableUri;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.SortKey;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.services.context.Context;
import org.forgerock.util.CloseSilentlyFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.Promise;

final class CrestAdapter
implements RequestHandler {
    private static final Status NOT_MODIFIED = Status.valueOf(304, "Not Modified");
    private final Handler handler;
    private final URI baseUri;

    public CrestAdapter(Handler handler, URI uri) {
        this.handler = Reject.checkNotNull(handler);
        this.baseUri = Reject.checkNotNull(uri);
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        this.prepareHttpRequest(request, httpRequest);
        httpRequest.setMethod("POST");
        Form form = new Form();
        form.putSingle(HttpUtils.PARAM_ACTION, request.getAction());
        form.appendRequestQuery(httpRequest);
        if (request.getContent() != null) {
            httpRequest.getEntity().setJson(request.getContent().getObject());
        }
        return this.handler.handle(context, httpRequest).then(CloseSilentlyFunction.closeSilently(new Function<org.forgerock.http.protocol.Response, ActionResponse, ResourceException>(){

            @Override
            public ActionResponse apply(org.forgerock.http.protocol.Response response) throws ResourceException {
                JsonValue content = CrestAdapter.loadJsonValueContent(response);
                if (Status.OK.equals(response.getStatus()) || Status.NO_CONTENT.equals(response.getStatus())) {
                    return (ActionResponse)CrestAdapter.setResourceVersion(response, Responses.newActionResponse(content));
                }
                throw CrestAdapter.createResourceException(response, content);
            }
        }), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        this.prepareHttpRequest(request, httpRequest);
        String resourceId = request.getNewResourceId();
        if (resourceId == null) {
            httpRequest.setMethod("POST");
        } else {
            httpRequest.setMethod("PUT");
            MutableUri uri = httpRequest.getUri();
            try {
                uri.setPath(uri.getPath() + "/" + request.getNewResourceId());
            }
            catch (URISyntaxException e) {
                return new InternalServerErrorException("Cannot rebuild resource path", (Throwable)e).asPromise();
            }
            CrestAdapter.setIfNoneMatchToAny(httpRequest);
        }
        if (request.getContent() != null) {
            httpRequest.getEntity().setJson(request.getContent().getObject());
        }
        return this.handler.handle(context, httpRequest).then(CloseSilentlyFunction.closeSilently(new Function<org.forgerock.http.protocol.Response, ResourceResponse, ResourceException>(){

            @Override
            public ResourceResponse apply(org.forgerock.http.protocol.Response response) throws ResourceException {
                JsonValue content = CrestAdapter.loadJsonValueContent(response);
                if (Status.CREATED.equals(response.getStatus())) {
                    return (ResourceResponse)CrestAdapter.setResourceVersion(response, CrestAdapter.createResourceResponse(content));
                }
                throw CrestAdapter.createResourceException(response, content);
            }
        }), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        httpRequest.setMethod("DELETE");
        this.prepareHttpRequest(request, httpRequest);
        CrestAdapter.setIfMatch(httpRequest, request.getRevision());
        return this.handler.handle(context, httpRequest).then(CrestAdapter.buildCrestResponse(Arrays.asList(Status.OK)), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        httpRequest.setMethod("PATCH");
        this.prepareHttpRequest(request, httpRequest);
        CrestAdapter.setIfMatch(httpRequest, request.getRevision());
        if (!request.getPatchOperations().isEmpty()) {
            JsonValue content = new JsonValue(new LinkedList());
            for (PatchOperation operation : request.getPatchOperations()) {
                content.add(operation.toJsonValue().getObject());
            }
            httpRequest.getEntity().setJson(content.getObject());
        }
        return this.handler.handle(context, httpRequest).then(CrestAdapter.buildCrestResponse(Arrays.asList(Status.OK)), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, final QueryResourceHandler queryHandler) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        this.prepareHttpRequest(request, httpRequest);
        httpRequest.setMethod("GET");
        Form form = new Form();
        CrestAdapter.putIfNotNull(form, HttpUtils.PARAM_QUERY_ID, request.getQueryId());
        CrestAdapter.putIfNotNull(form, HttpUtils.PARAM_QUERY_EXPRESSION, request.getQueryExpression());
        CrestAdapter.putIfNotNull(form, HttpUtils.PARAM_QUERY_FILTER, request.getQueryFilter());
        CrestAdapter.putIfNotNull(form, HttpUtils.PARAM_TOTAL_PAGED_RESULTS_POLICY, (Object)request.getTotalPagedResultsPolicy());
        CrestAdapter.putIfNotNull(form, HttpUtils.PARAM_PAGED_RESULTS_COOKIE, request.getPagedResultsCookie());
        List<SortKey> sortKeys = request.getSortKeys();
        if (sortKeys != null && !sortKeys.isEmpty()) {
            form.putSingle(HttpUtils.PARAM_SORT_KEYS, Utils.joinAsString(",", new Object[0]));
        }
        if (request.getPageSize() > 0) {
            form.putSingle(HttpUtils.PARAM_PAGE_SIZE, String.valueOf(request.getPageSize()));
        }
        if (request.getPagedResultsOffset() >= 1) {
            form.putSingle(HttpUtils.PARAM_PAGED_RESULTS_OFFSET, String.valueOf(request.getPagedResultsOffset()));
        }
        if (!form.isEmpty()) {
            form.appendRequestQuery(httpRequest);
        }
        return this.handler.handle(context, httpRequest).then(CloseSilentlyFunction.closeSilently(new Function<org.forgerock.http.protocol.Response, QueryResponse, ResourceException>(){

            @Override
            public QueryResponse apply(org.forgerock.http.protocol.Response response) throws ResourceException {
                JsonValue content = CrestAdapter.loadJsonValueContent(response);
                if (Status.OK.equals(response.getStatus()) && !content.isDefined("error")) {
                    String pagedResultsCookie = content.get("pagedResultsCookie").asString();
                    CountPolicy countPolicy = content.get("totalPagedResultsPolicy").as(JsonValueFunctions.enumConstant(CountPolicy.class));
                    Integer totalPagedResults = content.get("totalPagedResults").defaultTo(-1).asInteger();
                    QueryResponse queryResponse = Responses.newQueryResponse(pagedResultsCookie, countPolicy, totalPagedResults);
                    for (JsonValue value2 : content.get("result")) {
                        queryHandler.handleResource(CrestAdapter.createResourceResponse(value2));
                    }
                    return (QueryResponse)CrestAdapter.setResourceVersion(response, queryResponse);
                }
                throw CrestAdapter.createResourceException(response, content);
            }
        }), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        httpRequest.setMethod("GET");
        this.prepareHttpRequest(request, httpRequest);
        return this.handler.handle(context, httpRequest).then(CrestAdapter.buildCrestResponse(Arrays.asList(Status.OK, NOT_MODIFIED)), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        org.forgerock.http.protocol.Request httpRequest = new org.forgerock.http.protocol.Request();
        httpRequest.setMethod("PUT");
        this.prepareHttpRequest(request, httpRequest);
        CrestAdapter.setIfMatch(httpRequest, request.getRevision());
        if (request.getContent() != null) {
            httpRequest.getEntity().setJson(request.getContent().getObject());
        }
        return this.handler.handle(context, httpRequest).then(CrestAdapter.buildCrestResponse(Arrays.asList(Status.OK)), org.forgerock.http.protocol.Responses.noopExceptionFunction());
    }

    private static Function<org.forgerock.http.protocol.Response, ResourceResponse, ResourceException> buildCrestResponse(final List<Status> accepted) {
        return CloseSilentlyFunction.closeSilently(new Function<org.forgerock.http.protocol.Response, ResourceResponse, ResourceException>(){

            @Override
            public ResourceResponse apply(org.forgerock.http.protocol.Response response) throws ResourceException {
                JsonValue content = CrestAdapter.loadJsonValueContent(response);
                if (accepted.contains(response.getStatus())) {
                    return (ResourceResponse)CrestAdapter.setResourceVersion(response, CrestAdapter.createResourceResponse(content));
                }
                throw CrestAdapter.createResourceException(response, content);
            }
        });
    }

    private static void putIfNotNull(Form form, String name2, Object value2) {
        if (value2 != null) {
            form.putSingle(name2, value2.toString());
        }
    }

    private static JsonValue loadJsonValueContent(org.forgerock.http.protocol.Response response) throws ResourceException {
        if ("application/json".equals(ContentTypeHeader.valueOf(response).getType())) {
            try {
                return new JsonValue(response.getEntity().getJson());
            }
            catch (IOException e) {
                throw new InternalServerErrorException("Cannot parse HTTP response content as JSON", (Throwable)e);
            }
        }
        throw new InternalServerErrorException("Response is not application/json");
    }

    private static ResourceResponse createResourceResponse(JsonValue content) {
        return Responses.newResourceResponse(content.get("_id").asString(), content.get("_rev").asString(), content);
    }

    private static <T extends Response> T setResourceVersion(org.forgerock.http.protocol.Response httpResponse, T result2) {
        if (httpResponse.getHeaders().containsKey("Content-API-Version")) {
            Version resourceVersion = ContentApiVersionHeader.valueOf(httpResponse).getResourceVersion();
            result2.setResourceApiVersion(resourceVersion);
        }
        return result2;
    }

    private static void setRequestedResourceVersion(org.forgerock.http.protocol.Request request, Version resourceVersion) {
        request.getHeaders().put(new AcceptApiVersionHeader(HttpUtils.DEFAULT_PROTOCOL_VERSION, resourceVersion));
    }

    private static ResourceException createResourceException(org.forgerock.http.protocol.Response response, JsonValue content) {
        ResourceException exception2 = ResourceException.newResourceException(content.get("code").defaultTo(response.getStatus().getCode()).asInteger(), content.get("message").asString());
        if (content.isDefined("detail")) {
            exception2.setDetail(content.get("detail"));
        }
        if (content.isDefined("reason")) {
            exception2.setReason(content.get("reason").asString());
        }
        return CrestAdapter.setResourceVersion(response, exception2);
    }

    private static void setIfMatch(org.forgerock.http.protocol.Request request, String revision) {
        String value2 = "*";
        if (revision != null) {
            value2 = String.format("\"%s\"", revision);
        }
        request.getHeaders().put("If-Match", (Object)value2);
    }

    private static void setIfNoneMatchToAny(org.forgerock.http.protocol.Request request) {
        request.getHeaders().put("If-None-Match", (Object)"*");
    }

    private void prepareHttpRequest(Request request, org.forgerock.http.protocol.Request httpRequest) {
        CrestAdapter.setRequestedResourceVersion(httpRequest, request.getResourceVersion());
        httpRequest.setUri(this.baseUri.resolve(request.getResourcePath()));
        Form form = new Form();
        if (!request.getFields().isEmpty()) {
            form.putSingle(HttpUtils.PARAM_FIELDS, Utils.joinAsString(",", request.getFields().toArray()));
        }
        for (Map.Entry<String, String> entry : request.getAdditionalParameters().entrySet()) {
            form.putSingle(entry.getKey(), entry.getValue());
        }
        if (!form.isEmpty()) {
            form.toRequestQuery(httpRequest);
        }
    }
}

