/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AdviceContext;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestVisitor;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.encode.Base64url;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

final class RequestRunner
implements RequestVisitor<Promise<org.forgerock.http.protocol.Response, NeverThrowsException>, Void> {
    private Connection connection = null;
    private final Context context;
    private final org.forgerock.http.protocol.Request httpRequest;
    private final org.forgerock.http.protocol.Response httpResponse;
    private final Version protocolVersion;
    private final Request request;
    private final JsonGenerator jsonGenerator;

    RequestRunner(Context context, Request request, org.forgerock.http.protocol.Request httpRequest, org.forgerock.http.protocol.Response httpResponse) throws Exception {
        this.context = context;
        this.request = request;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.protocolVersion = HttpUtils.getRequestedProtocolVersion(httpRequest);
        this.jsonGenerator = HttpUtils.getJsonGenerator(httpRequest, httpResponse);
    }

    private boolean isUpsertSupported(CreateRequest request) {
        return this.protocolVersion.getMajor() >= 2 && HttpUtils.getIfNoneMatch(this.httpRequest) == null && request.getNewResourceId() != null;
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> handleError(ResourceException error2) {
        this.onError(error2);
        this.writeApiVersionHeaders(error2);
        this.writeAdvice();
        return HttpUtils.fail(this.httpRequest, this.httpResponse, error2);
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> handleResult(Connection result2) {
        this.connection = result2;
        return this.request.accept(this, null);
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitActionRequest(Void p2, ActionRequest request) {
        return this.connection.actionAsync(this.context, request).thenAsync(new AsyncFunction<ActionResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ActionResponse result2) {
                try {
                    RequestRunner.this.writeApiVersionHeaders(result2);
                    RequestRunner.this.writeAdvice();
                    if (result2 != null) {
                        Json.makeLocalizingObjectWriter(HttpUtils.JSON_MAPPER, RequestRunner.this.httpRequest).writeValue(RequestRunner.this.jsonGenerator, result2.getJsonContent().getObject());
                    } else {
                        RequestRunner.this.httpResponse.setStatus(Status.NO_CONTENT);
                    }
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
                return Promises.newResultPromise(RequestRunner.this.httpResponse);
            }
        }, new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitCreateRequest(final Void p2, final CreateRequest request) {
        return this.connection.createAsync(this.context, request).thenAsync(new AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceResponse result2) {
                try {
                    RequestRunner.this.writeApiVersionHeaders(result2);
                    RequestRunner.this.writeAdvice();
                    if (result2.getId() != null) {
                        RequestRunner.this.httpResponse.getHeaders().put("Location", (Object)RequestRunner.this.getResourceURL(result2));
                    }
                    RequestRunner.this.httpResponse.setStatus(Status.CREATED);
                    RequestRunner.this.writeResource(result2);
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
                return Promises.newResultPromise(RequestRunner.this.httpResponse);
            }
        }, new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException resourceException) {
                try {
                    if (resourceException instanceof PreconditionFailedException && RequestRunner.this.isUpsertSupported(request)) {
                        return RequestRunner.this.visitUpdateRequest(p2, Requests.newUpdateRequest(request.getResourcePathObject().child(request.getNewResourceId()), request.getContent()));
                    }
                    return RequestRunner.this.handleError(resourceException);
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                    return Promises.newResultPromise(RequestRunner.this.httpResponse);
                }
            }
        });
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitDeleteRequest(Void p2, DeleteRequest request) {
        return this.connection.deleteAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitPatchRequest(Void p2, PatchRequest request) {
        return this.connection.patchAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitQueryRequest(Void p2, QueryRequest request) {
        final AtomicBoolean isFirstResult = new AtomicBoolean(true);
        final AtomicInteger resultCount = new AtomicInteger(0);
        return this.connection.queryAsync(this.context, request, new QueryResourceHandler(){

            @Override
            public boolean handleResource(ResourceResponse resource2) {
                try {
                    RequestRunner.this.writeHeader(resource2, isFirstResult);
                    RequestRunner.this.writeResourceJsonContent(resource2);
                    resultCount.incrementAndGet();
                    return true;
                }
                catch (Exception e) {
                    RequestRunner.this.handleError(HttpUtils.adapt(e));
                    return false;
                }
            }
        }).thenOnResult(new ResultHandler<QueryResponse>(){

            @Override
            public void handleResult(QueryResponse result2) {
                try {
                    RequestRunner.this.writeHeader(result2, isFirstResult);
                    RequestRunner.this.jsonGenerator.writeEndArray();
                    RequestRunner.this.jsonGenerator.writeNumberField("resultCount", resultCount.get());
                    RequestRunner.this.jsonGenerator.writeStringField("pagedResultsCookie", result2.getPagedResultsCookie());
                    RequestRunner.this.jsonGenerator.writeStringField("totalPagedResultsPolicy", result2.getTotalPagedResultsPolicy().toString());
                    RequestRunner.this.jsonGenerator.writeNumberField("totalPagedResults", result2.getTotalPagedResults());
                    RequestRunner.this.jsonGenerator.writeNumberField("remainingPagedResults", result2.getRemainingPagedResults());
                    RequestRunner.this.jsonGenerator.writeEndObject();
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
            }
        }).thenOnException(new ExceptionHandler<ResourceException>(){

            @Override
            public void handleException(ResourceException error2) {
                if (isFirstResult.get()) {
                    RequestRunner.this.onError(error2);
                } else {
                    try {
                        RequestRunner.this.jsonGenerator.writeEndArray();
                        RequestRunner.this.jsonGenerator.writeNumberField("resultCount", resultCount.get());
                        RequestRunner.this.jsonGenerator.writeObjectField("error", error2.toJsonValue().getObject());
                        RequestRunner.this.jsonGenerator.writeEndObject();
                        RequestRunner.this.onSuccess();
                    }
                    catch (Exception e) {
                        RequestRunner.this.onError(e);
                    }
                }
            }
        }).thenAsync(new AsyncFunction<QueryResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(QueryResponse queryResponse) {
                return Promises.newResultPromise(RequestRunner.this.httpResponse);
            }
        }, new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    private void writeHeader(Response response, AtomicBoolean isFirstResult) throws IOException {
        if (isFirstResult.compareAndSet(true, false)) {
            this.writeApiVersionHeaders(response);
            this.writeAdvice();
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeArrayFieldStart("result");
        }
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitReadRequest(Void p2, ReadRequest request) {
        return this.connection.readAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    @Override
    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitUpdateRequest(Void p2, UpdateRequest request) {
        return this.connection.updateAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    private void onSuccess() {
        Utils.closeSilently(this.connection, this.jsonGenerator);
    }

    private void onError(Exception e) {
        Utils.closeSilently(this.connection);
    }

    private String getResourceURL(ResourceResponse resource2) {
        StringBuilder builder = new StringBuilder().append(this.httpRequest.getUri().getScheme()).append("://").append(this.httpRequest.getUri().getRawAuthority());
        String baseUri = this.context.asContext(UriRouterContext.class).getBaseUri();
        if (!baseUri.isEmpty()) {
            if (!baseUri.startsWith("/")) {
                builder.append('/');
            }
            builder.append(baseUri);
        }
        builder.append('/');
        builder.append(resource2.getId());
        return builder.toString();
    }

    private AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException> newResourceSuccessHandler() {
        return new AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            @Override
            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceResponse result2) {
                try {
                    String rev;
                    RequestRunner.this.writeApiVersionHeaders(result2);
                    RequestRunner.this.writeAdvice();
                    if (RequestRunner.this.request instanceof ReadRequest && (rev = HttpUtils.getIfNoneMatch(RequestRunner.this.httpRequest)) != null && rev.equals(result2.getRevision())) {
                        Map<String, Object> responseBody = ResourceException.newResourceException(304).setReason("Not Modified").toJsonValue().asMap();
                        return Promises.newResultPromise(new org.forgerock.http.protocol.Response(Status.valueOf(304)).setEntity(responseBody));
                    }
                    RequestRunner.this.writeResource(result2);
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
                return Promises.newResultPromise(RequestRunner.this.httpResponse);
            }
        };
    }

    private void writeTextValue(JsonValue json) throws IOException {
        if (json.isMap() && !json.asMap().isEmpty()) {
            this.writeToResponse(json.asMap().entrySet().iterator().next().getValue().toString().getBytes());
        } else if (json.isList() && !json.asList().isEmpty()) {
            this.writeToResponse(json.asList(String.class).iterator().next().getBytes());
        } else if (json.isString()) {
            this.writeToResponse(json.asString().getBytes());
        } else if (json.isBoolean()) {
            this.writeToResponse(json.asBoolean().toString().getBytes());
        } else if (json.isNumber()) {
            this.writeToResponse(json.asNumber().toString().getBytes());
        } else {
            throw new IOException("Content is unknown type or is empty");
        }
    }

    private void writeBinaryValue(JsonValue json) throws IOException {
        if (json.isMap() && !json.asMap().isEmpty()) {
            this.writeToResponse(Base64url.decode(json.asMap().entrySet().iterator().next().getValue().toString()));
        } else if (json.isList() && !json.asList().isEmpty()) {
            this.writeToResponse(Base64url.decode(json.asList(String.class).iterator().next()));
        } else if (json.isString()) {
            this.writeToResponse(Base64url.decode(json.asString()));
        } else {
            throw new IOException("Content is not an accepted type or is empty");
        }
    }

    private void writeToResponse(byte[] data2) throws IOException {
        if (data2 == null || data2.length == 0) {
            throw new IOException("Content is empty or corrupt");
        }
        this.httpResponse.setEntity(data2);
    }

    private void writeResource(ResourceResponse resource2) throws IOException, ParseException, MalformedHeaderException {
        ContentType contentType;
        if (resource2.getRevision() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            builder.append(resource2.getRevision());
            builder.append('\"');
            this.httpResponse.getHeaders().put("ETag", (Object)builder.toString());
        }
        if ((contentType = new ContentType(this.httpResponse.getHeaders().getFirst(ContentTypeHeader.class))).match("application/json")) {
            this.writeResourceJsonContent(resource2);
        } else if (contentType.match("text/plain")) {
            this.writeTextValue(resource2.getContent());
        } else {
            this.writeBinaryValue(resource2.getContent());
        }
    }

    private void writeResourceJsonContent(ResourceResponse resource2) throws IOException, MalformedHeaderException {
        ObjectWriter objectWriter = Json.makeLocalizingObjectWriter(HttpUtils.JSON_MAPPER, this.httpRequest);
        if (HttpUtils.getRequestedProtocolVersion(this.httpRequest).getMajor() >= HttpUtils.PROTOCOL_VERSION_2.getMajor()) {
            this.jsonGenerator.writeStartObject();
            JsonValue content = resource2.getContent();
            if (resource2.getId() != null) {
                this.jsonGenerator.writeObjectField("_id", resource2.getId());
            } else {
                Object id2 = content.get("_id").getObject();
                if (id2 != null) {
                    this.jsonGenerator.writeObjectField("_id", id2.toString());
                }
            }
            if (resource2.getRevision() != null) {
                this.jsonGenerator.writeObjectField("_rev", resource2.getRevision());
            } else {
                Object rev = content.get("_rev").getObject();
                if (rev != null) {
                    this.jsonGenerator.writeObjectField("_rev", rev.toString());
                }
            }
            for (Map.Entry<String, Object> property : content.asMap().entrySet()) {
                String key2 = property.getKey();
                if ("_id".equals(key2) || "_rev".equals(key2)) continue;
                this.jsonGenerator.writeFieldName(key2);
                objectWriter.writeValue(this.jsonGenerator, property.getValue());
            }
            this.jsonGenerator.writeEndObject();
        } else {
            objectWriter.writeValue(this.jsonGenerator, resource2.getContent().getObject());
        }
    }

    private void writeApiVersionHeaders(Response response) {
        if (response.getResourceApiVersion() != null) {
            this.httpResponse.getHeaders().put(new ContentApiVersionHeader(this.protocolVersion, response.getResourceApiVersion()));
        }
    }

    private void writeAdvice() {
        if (this.context.containsContext(AdviceContext.class)) {
            AdviceContext adviceContext = this.context.asContext(AdviceContext.class);
            for (Map.Entry<String, List<String>> entry : adviceContext.getAdvices().entrySet()) {
                this.httpResponse.getHeaders().put(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

