/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http.examples;

import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import org.asciidoctor.Asciidoctor;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.DescribedHttpApplication;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.example.DescribedOauth2Endpoint;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.swagger.SwaggerApiProducer;
import org.forgerock.json.resource.Applications;
import org.forgerock.json.resource.MemoryBackend;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.descriptor.examples.handler.UserCollectionHandler;
import org.forgerock.json.resource.http.CrestHttp;
import org.forgerock.util.Factory;

public class CrestHttpApplication
implements DescribedHttpApplication {
    private static final String SWAGGER_JSON_ROUTE = "../..?_api";
    private static final ContentTypeHeader HTML_CONTENT_TYPE_HEADER = ContentTypeHeader.valueOf("text/html; charset=UTF-8");

    @Override
    public Handler start() throws HttpApplicationException {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        Router crestRouter = new Router();
        crestRouter.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/users"), Resources.newHandler(new MemoryBackend()));
        crestRouter.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/groups"), Resources.newHandler(new MemoryBackend()));
        crestRouter.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/api/users"), UserCollectionHandler.getUsersRouter());
        crestRouter.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/api/admins"), UserCollectionHandler.getAdminsRouter());
        Handler crestHandler = CrestHttp.newHttpHandler(Applications.simpleCrestApplication(Resources.newInternalConnectionFactory(crestRouter), "frapi:example", "1.0"));
        org.forgerock.http.routing.Router router = new org.forgerock.http.routing.Router();
        router.setDefaultRoute(crestHandler);
        router.addRoute(org.forgerock.http.routing.RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/chf/oauth2"), new DescribedOauth2Endpoint());
        router.addRoute(org.forgerock.http.routing.RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, "/docs/html"), new /* Unavailable Anonymous Inner Class!! */);
        router.addRoute(org.forgerock.http.routing.RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "/docs/api"), new /* Unavailable Anonymous Inner Class!! */);
        router.addRoute(new /* Unavailable Anonymous Inner Class!! */, new /* Unavailable Anonymous Inner Class!! */);
        return router;
    }

    @Override
    public Factory<Buffer> getBufferFactory() {
        return null;
    }

    @Override
    public void stop() {
    }

    @Override
    public ApiProducer<Swagger> getApiProducer() {
        return new SwaggerApiProducer(new Info().title("CREST Examples"), null, null, Scheme.HTTP);
    }

    static /* synthetic */ ContentTypeHeader access$000() {
        return HTML_CONTENT_TYPE_HEADER;
    }
}

