/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services;

import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Reject;
import org.forgerock.util.generator.IdGenerator;

public final class TransactionId {
    private final String value;
    private final AtomicInteger subTransactionIdCounter;

    public TransactionId() {
        this(IdGenerator.DEFAULT.generate());
    }

    public TransactionId(String value2) {
        this(value2, 0);
    }

    private TransactionId(String value2, int counter) {
        Reject.ifTrue(value2 == null || value2.isEmpty(), "The value must not be null nor empty.");
        this.value = value2;
        this.subTransactionIdCounter = new AtomicInteger(counter);
    }

    public String getValue() {
        return this.value;
    }

    public TransactionId createSubTransactionId() {
        String subTransactionId = this.value + "/" + this.subTransactionIdCounter.getAndIncrement();
        return new TransactionId(subTransactionId);
    }

    public JsonValue toJson() {
        return JsonValue.json(JsonValue.object(JsonValue.field("value", this.value), JsonValue.field("subTransactionIdCounter", this.subTransactionIdCounter.get())));
    }

    public static TransactionId valueOf(JsonValue value2) {
        return new TransactionId(value2.get("value").required().asString(), value2.get("subTransactionIdCounter").required().asInteger());
    }
}

