/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services.context;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;

public final class SecurityContext
extends AbstractContext {
    public static final String AUTHZID_COMPONENT = "component";
    public static final String AUTHZID_DN = "dn";
    public static final String AUTHZID_ID = "id";
    public static final String AUTHZID_REALM = "realm";
    public static final String AUTHZID_ROLES = "roles";
    private static final String ATTR_AUTHENTICATION_ID = "authenticationId";
    private static final String ATTR_AUTHORIZATION = "authorization";

    public SecurityContext(Context parent, String authenticationId, Map<String, Object> authorization) {
        this(null, parent, authenticationId, authorization);
    }

    public SecurityContext(String id2, Context parent, String authenticationId, Map<String, Object> authorization) {
        super(id2, "security", Reject.checkNotNull(parent, "Cannot instantiate SecurityContext with null parent Context"));
        this.data.put(ATTR_AUTHENTICATION_ID, (Object)(authenticationId != null ? authenticationId : ""));
        this.data.put(ATTR_AUTHORIZATION, authorization != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(authorization)) : Collections.emptyMap());
    }

    public SecurityContext(JsonValue savedContext, ClassLoader classLoader) {
        super(savedContext, classLoader);
    }

    public String getAuthenticationId() {
        return this.data.get(ATTR_AUTHENTICATION_ID).asString();
    }

    public Map<String, Object> getAuthorization() {
        return this.data.get(ATTR_AUTHORIZATION).asMap();
    }
}

