/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.Duration;

public class PerItemEvictionStrategyCache<K, V> {
    private static final Function<Exception, Duration, Exception> ON_EXCEPTION_NO_TIMEOUT = new Function<Exception, Duration, Exception>(){

        @Override
        public Duration apply(Exception e) throws Exception {
            return Duration.ZERO;
        }
    };
    private final ScheduledExecutorService executorService;
    private final ConcurrentMap<K, CacheEntry<V>> cache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final AsyncFunction<V, Duration, Exception> defaultTimeoutFunction;
    private Duration maxTimeout;

    public PerItemEvictionStrategyCache(ScheduledExecutorService executorService, final Duration defaultTimeout) {
        this(executorService, new AsyncFunction<V, Duration, Exception>(){

            @Override
            public Promise<Duration, Exception> apply(V value2) {
                return Promises.newResultPromise(defaultTimeout);
            }
        });
    }

    public PerItemEvictionStrategyCache(ScheduledExecutorService executorService, AsyncFunction<V, Duration, Exception> defaultTimeoutFunction) {
        this.executorService = Reject.checkNotNull(executorService);
        this.defaultTimeoutFunction = Reject.checkNotNull(defaultTimeoutFunction);
    }

    public V getValue(K key2, Callable<V> callable) throws InterruptedException, ExecutionException {
        return this.getValue(key2, callable, this.defaultTimeoutFunction);
    }

    public V getValue(K key2, Callable<V> callable, AsyncFunction<V, Duration, Exception> expire) throws InterruptedException, ExecutionException {
        try {
            return this.createIfAbsent(key2, callable, expire).get();
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            this.evict(key2);
            throw e;
        }
    }

    private Future<V> createIfAbsent(K key2, Callable<V> callable, AsyncFunction<V, Duration, Exception> timeoutFunction) throws InterruptedException, ExecutionException {
        FutureTask<V> futureTask;
        CacheEntry<V> futureCacheEntry;
        CacheEntry<V> cacheEntry = (CacheEntry<V>)this.cache.get(key2);
        if (cacheEntry == null && (cacheEntry = this.cache.putIfAbsent(key2, futureCacheEntry = new CacheEntry<V>(futureTask = new FutureTask<V>(callable)))) == null) {
            cacheEntry = futureCacheEntry;
            futureTask.run();
            this.scheduleEviction(key2, futureCacheEntry, timeoutFunction);
        }
        return cacheEntry.getFutureTask();
    }

    private void scheduleEviction(final K key2, final CacheEntry<V> cacheEntry, AsyncFunction<V, Duration, Exception> timeoutFunction) throws ExecutionException, InterruptedException {
        Promises.newResultPromise(cacheEntry.getFutureTask().get()).thenAsync(timeoutFunction).thenCatch(ON_EXCEPTION_NO_TIMEOUT).thenCatchRuntimeException(ON_EXCEPTION_NO_TIMEOUT).thenOnResult(new ResultHandler<Duration>(){

            @Override
            public void handleResult(Duration timeout2) {
                Runnable eviction = new Runnable(){

                    @Override
                    public void run() {
                        if (PerItemEvictionStrategyCache.this.cache.remove(key2, cacheEntry)) {
                            cacheEntry.cancelExpiration();
                        }
                    }
                };
                if (timeout2 == null || timeout2.isZero()) {
                    eviction.run();
                } else {
                    if (PerItemEvictionStrategyCache.this.maxTimeout != null) {
                        Duration duration = timeout2 = timeout2.compareTo(PerItemEvictionStrategyCache.this.maxTimeout) < 0 ? timeout2 : PerItemEvictionStrategyCache.this.maxTimeout;
                    }
                    if (!timeout2.isUnlimited()) {
                        ScheduledFuture<?> scheduledFuture = PerItemEvictionStrategyCache.this.executorService.schedule(eviction, timeout2.getValue(), timeout2.getUnit());
                        cacheEntry.setScheduledHandler(scheduledFuture);
                    }
                }
            }
        });
    }

    public void clear() {
        for (Object key2 : this.cache.keySet()) {
            this.evict(key2);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void evict(K key2) {
        CacheEntry entry = (CacheEntry)this.cache.remove(key2);
        if (entry != null) {
            entry.cancelExpiration();
        }
    }

    public Duration getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(Duration maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    private static class CacheEntry<V> {
        private final FutureTask<V> futureTask;
        private ScheduledFuture<?> scheduledHandler;

        CacheEntry(FutureTask<V> futureTask) {
            this.futureTask = futureTask;
        }

        void setScheduledHandler(ScheduledFuture<?> scheduledHandler) {
            this.scheduledHandler = scheduledHandler;
        }

        FutureTask<V> getFutureTask() {
            return this.futureTask;
        }

        void cancelExpiration() {
            if (this.scheduledHandler != null) {
                this.scheduledHandler.cancel(false);
            }
        }
    }
}

