/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeSet
extends AbstractSet<Integer>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int start;
    private final int stop;
    private final int step;

    public RangeSet(int stop2) {
        this(0, stop2, 1);
    }

    public RangeSet(int start2, int stop2) {
        this(start2, stop2, 1);
    }

    public RangeSet(int start2, int stop2, int step2) {
        if (step2 == 0) {
            throw new IllegalArgumentException();
        }
        this.start = start2;
        this.stop = stop2;
        this.step = step2;
    }

    @Override
    public int size() {
        int difference = this.stop - this.start;
        int count2 = difference / this.step;
        int remainder2 = Math.abs(difference % this.step);
        return count2 > 0 ? count2 + remainder2 : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        boolean result2 = false;
        if (o != null && o instanceof Integer && this.size() != 0) {
            int contains = ((Number)o).intValue();
            if (this.step > 0 && contains >= this.start && contains < this.stop || this.step < 0 && contains >= this.start && contains > this.stop) {
                result2 = (contains - this.start) % this.step == 0;
            }
        }
        return result2;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int cursor;
            {
                this.cursor = RangeSet.this.start;
            }

            @Override
            public boolean hasNext() {
                boolean result2 = RangeSet.this.step > 0 ? this.cursor < RangeSet.this.stop : this.cursor > RangeSet.this.stop;
                return result2;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int result2 = this.cursor;
                this.cursor += RangeSet.this.step;
                return result2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

