/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

public final class Reject {
    public static <T> T checkNotNull(T object) {
        return Reject.checkNotNull(object, null);
    }

    public static <T> T checkNotNull(T object, String message2) {
        if (object == null) {
            throw new NullPointerException(message2);
        }
        return object;
    }

    public static void ifFalse(boolean condition) {
        Reject.ifFalse(condition, "Expected condition was true, found false");
    }

    public static void ifFalse(boolean condition, String message2) {
        if (!condition) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void ifNull(Object object) {
        Reject.ifNull(object, null);
    }

    @SafeVarargs
    public static <T> void ifNull(T ... objects) {
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
    }

    public static void ifNull(Object object, String message2) {
        Reject.checkNotNull(object, message2);
    }

    public static void ifTrue(boolean condition) {
        Reject.ifTrue(condition, "Expected condition was false, found true");
    }

    public static void ifTrue(boolean condition, String message2) {
        if (condition) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void rejectStateIfTrue(boolean condition, String message2) {
        if (condition) {
            throw new IllegalStateException(message2);
        }
    }

    private Reject() {
    }
}

