/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.util.Reject;

public final class Utils {
    public static void closeSilently(Closeable ... resources) {
        if (resources == null) {
            return;
        }
        Utils.closeSilently(Arrays.asList(resources));
    }

    public static void closeSilently(Iterable<? extends Closeable> resources) {
        if (resources == null) {
            return;
        }
        for (Closeable closeable : resources) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String joinAsString(String separator, Object ... values2) {
        return Utils.joinAsString(separator, Arrays.asList(values2));
    }

    public static String joinAsString(String separator, Iterable<?> values2) {
        Reject.ifNull(separator);
        Reject.ifNull(values2);
        StringBuilder builder = new StringBuilder();
        Utils.joinAsString(builder, separator, values2);
        return builder.toString();
    }

    public static void joinAsString(StringBuilder builder, String separator, Object ... values2) {
        Utils.joinAsString(builder, separator, Arrays.asList(values2));
    }

    public static void joinAsString(StringBuilder builder, String separator, Iterable<?> values2) {
        Reject.ifNull(builder);
        Reject.ifNull(separator);
        Reject.ifNull(values2);
        Iterator<?> iterator = values2.iterator();
        if (iterator.hasNext()) {
            builder.append(iterator.next());
            while (iterator.hasNext()) {
                builder.append(separator);
                builder.append(iterator.next());
            }
        }
    }

    public static ThreadFactory newThreadFactory(final ThreadGroup group2, final String nameTemplate, final boolean isDaemon) {
        return new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String name2 = String.format(nameTemplate, this.count.getAndIncrement());
                Thread t = new Thread(group2, r, name2);
                t.setDaemon(isDaemon);
                return t;
            }
        };
    }

    public static <T extends Enum<T>> T asEnum(String value2, Class<T> type2) {
        if (value2 == null) {
            return null;
        }
        Object[] constants2 = (Enum[])type2.getEnumConstants();
        if (constants2 == null) {
            throw new IllegalArgumentException("Type is not an enum class");
        }
        Object[] objectArray = constants2;
        int n = constants2.length;
        int n2 = 0;
        while (n2 < n) {
            Enum constant = objectArray[n2];
            if (value2.equalsIgnoreCase(constant.toString())) {
                return (T)constant;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder("Expecting String containing one of: ");
        sb.append(Utils.joinAsString(" ", constants2));
        throw new IllegalArgumentException(sb.toString());
    }

    public static boolean isNullOrEmpty(String value2) {
        return value2 == null || value2.isEmpty();
    }

    private Utils() {
    }
}

